/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.kofx;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.kofx.FXContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

final class LoadJSON
implements Runnable {
    private static final Logger LOG = FXContext.LOG;
    private static final Executor REQ = Executors.newCachedThreadPool();
    private final JSONCall call;
    private final URL base;
    private Throwable error;
    private Object json;

    private LoadJSON(JSONCall call) {
        URL b;
        this.call = call;
        try {
            b = new URL(LoadJSON.findBaseURL());
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.SEVERE, "Can't find base url for " + call.composeURL("dummy"), ex);
            b = null;
        }
        this.base = b;
    }

    public static void loadJSON(JSONCall call) {
        REQ.execute(new LoadJSON(call));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Platform.isFxApplicationThread()) {
            if (this.error != null) {
                this.call.notifyError(this.error);
            } else {
                this.call.notifySuccess(this.json);
            }
            return;
        }
        String url = this.call.isJSONP() ? this.call.composeURL("dummy") : this.call.composeURL(null);
        try {
            int ch;
            URL u = new URL(this.base, url.replace(" ", "%20"));
            URLConnection conn = u.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection huc = (HttpURLConnection)conn;
                if (this.call.getMethod() != null) {
                    huc.setRequestMethod(this.call.getMethod());
                }
                if (this.call.isDoOutput()) {
                    huc.setDoOutput(true);
                    OutputStream os = huc.getOutputStream();
                    this.call.writeData(os);
                    os.flush();
                }
            }
            PushbackInputStream is = new PushbackInputStream(conn.getInputStream(), 1);
            boolean array = false;
            boolean string = false;
            if (this.call.isJSONP()) {
                while ((ch = is.read()) != -1) {
                    if (ch == 91) {
                        is.unread(ch);
                        array = true;
                    } else {
                        if (ch != 123) continue;
                        is.unread(ch);
                    }
                    break;
                }
            } else {
                ch = is.read();
                array = ch == 91;
                is.unread(ch);
                if (!array && ch != 123) {
                    string = true;
                }
            }
            try {
                if (string) {
                    throw new JSONException("");
                }
                InputStreamReader r = new InputStreamReader((InputStream)is, "UTF-8");
                JSONTokener tok = new JSONTokener((Reader)r);
                JSONArray obj = array ? new JSONArray(tok) : new JSONObject(tok);
                this.json = LoadJSON.convertToArray(obj);
            }
            catch (JSONException ex) {
                int ch2;
                InputStreamReader r = new InputStreamReader((InputStream)is, "UTF-8");
                StringBuilder sb = new StringBuilder();
                while ((ch2 = ((Reader)r).read()) != -1) {
                    sb.append((char)ch2);
                }
                this.json = sb.toString();
            }
        }
        catch (IOException ex) {
            this.error = ex;
            LOG.log(Level.WARNING, "Cannot connect to " + url, ex);
        }
        finally {
            Platform.runLater((Runnable)this);
        }
    }

    private static Object convertToArray(Object o) throws JSONException {
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            Object[] arr = new Object[ja.length()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = LoadJSON.convertToArray(ja.get(i));
            }
            return arr;
        }
        if (o instanceof JSONObject) {
            JSONObject obj = (JSONObject)o;
            Iterator it = obj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                obj.put(key, LoadJSON.convertToArray(obj.get(key)));
            }
            return obj;
        }
        return o;
    }

    public static void extractJSON(Object jsonObject, String[] props, Object[] values) {
        int i;
        Object obj;
        if (jsonObject instanceof JSONObject) {
            obj = (JSONObject)jsonObject;
            for (i = 0; i < props.length; ++i) {
                try {
                    values[i] = obj.has(props[i]) ? obj.get(props[i]) : null;
                    continue;
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, "Can't read " + props[i] + " from " + jsonObject, ex);
                }
            }
        }
        if (jsonObject instanceof JSObject) {
            obj = (JSObject)jsonObject;
            for (i = 0; i < props.length; ++i) {
                Object val = ((JSObject)obj).getMember(props[i]);
                values[i] = LoadJSON.isDefined(val) ? val : null;
            }
        }
    }

    public static Object parse(InputStream is) throws IOException {
        try {
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            JSONTokener t = new JSONTokener((Reader)r);
            return new JSONObject(t);
        }
        catch (JSONException ex) {
            throw new IOException(ex);
        }
    }

    private static String findBaseURL() {
        WebEngine eng = (WebEngine)System.getProperties().get("webEngine");
        return (String)eng.executeScript("var h;if (!!window && !!window.location && !!window.location.href)\n  h = window.location.href;\nelse   h = null;h\n");
    }

    private static boolean isDefined(Object val) {
        return !"undefined".equals(val);
    }
}

