/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.kofx;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.html.js.JavaScriptBody;
import net.java.html.js.JavaScriptResource;
import netscape.javascript.JSObject;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.kofx.Console;

@JavaScriptResource(value="knockout-2.2.1.js")
public final class Knockout {
    private static final Logger LOG = Logger.getLogger(Knockout.class.getName());
    static Knockout next;
    private final Object model;
    private static int cnt;

    Knockout(Object model) {
        this.model = model == null ? this : model;
    }

    public Object koData() {
        return this.model;
    }

    static Object toArray(Object[] arr) {
        return InvokeJS.KObject.call("array", arr);
    }

    public static <M> Knockout createBinding(Object model) {
        Object bindings = InvokeJS.create(model, ++cnt);
        return new Knockout(bindings);
    }

    public void valueHasMutated(String prop) {
        Knockout.valueHasMutated((JSObject)this.model, prop);
    }

    public static void valueHasMutated(JSObject model, String prop) {
        LOG.log(Level.FINE, "property mutated: {0}", prop);
        try {
            Object koProp = model.getMember(prop);
            if (koProp instanceof JSObject) {
                ((JSObject)koProp).call("valueHasMutated", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "valueHasMutated failed for " + model + " prop: " + prop, t);
        }
    }

    static void bind(Object bindings, Object model, PropertyBinding pb, boolean primitive, boolean array) {
        String prop = pb.getPropertyName();
        try {
            InvokeJS.bind(bindings, pb, prop, "getValue", pb.isReadOnly() ? null : "setValue", primitive, array);
            ((JSObject)bindings).setMember("ko-fx.model", model);
            LOG.log(Level.FINE, "binding defined for {0}: {1}", new Object[]{prop, ((JSObject)bindings).getMember(prop)});
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "binding failed for {0} on {1}", new Object[]{prop, bindings});
        }
    }

    static void expose(Object bindings, FunctionBinding f) {
        String prop = f.getFunctionName();
        try {
            InvokeJS.expose(bindings, f, prop, "call");
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Cannot define binding for " + prop + " in model " + f, ex);
        }
    }

    static void applyBindings(Object bindings) {
        InvokeJS.applyBindings(bindings);
    }

    private static final class InvokeJS {
        static final JSObject KObject;

        private InvokeJS() {
        }

        @JavaScriptBody(args={"s"}, body="return eval(s);")
        private static native Object exec(String var0);

        @JavaScriptBody(args={}, body="  var k = {};  k.array= function() {    return Array.prototype.slice.call(arguments);  };  return k;")
        private static native Object kObj();

        @JavaScriptBody(args={"value", "cnt "}, body="    var ret = {};    ret.toString = function() { return 'KObject' + cnt + ' value: ' + value + ' props: ' + Object.keys(this); };    return ret;")
        static native Object create(Object var0, int var1);

        @JavaScriptBody(args={"bindings", "model", "prop", "sig"}, body="    bindings[prop] = function(data, ev) {      model[sig](data, ev);    };")
        static native Object expose(Object var0, Object var1, String var2, String var3);

        @JavaScriptBody(args={"bindings", "model", "prop", "getter", "setter", "primitive", "array"}, body="    var bnd = {      read: function() {      try {        var v = model[getter]();        return v;      } catch (e) {        alert(\"Cannot call \" + getter + \" on \" + model + \" error: \" + e);      }    },    owner: bindings    };    if (setter != null) {      bnd.write = function(val) {        model[setter](primitive ? new Number(val) : val);      };    };    bindings[prop] = ko.computed(bnd);")
        static native void bind(Object var0, Object var1, String var2, String var3, String var4, boolean var5, boolean var6);

        @JavaScriptBody(args={"bindings"}, body="ko.applyBindings(bindings);")
        private static native void applyBindings(Object var0);

        static {
            Console.register();
            KObject = (JSObject)InvokeJS.kObj();
        }
    }
}

