/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.kofx;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import net.java.html.js.JavaScriptBody;
import netscape.javascript.JSObject;
import org.apidesign.html.context.spi.Contexts;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;
import org.apidesign.html.kofx.Knockout;
import org.apidesign.html.kofx.LoadJSON;

public final class FXContext
implements Technology<JSObject>,
Transfer,
Contexts.Provider {
    static final Logger LOG = Logger.getLogger(FXContext.class.getName());

    @JavaScriptBody(args={}, body="return true;")
    private static boolean isJavaScriptEnabled() {
        return false;
    }

    public void fillContext(Contexts.Builder context, Class<?> requestor) {
        if (FXContext.isJavaScriptEnabled()) {
            context.register(Technology.class, (Object)this, 100);
            context.register(Transfer.class, (Object)this, 100);
        }
    }

    public JSObject wrapModel(Object model) {
        return (JSObject)Knockout.createBinding(model).koData();
    }

    public void bind(PropertyBinding b, Object model, JSObject data) {
        boolean isList = false;
        boolean isPrimitive = false;
        Knockout.bind(data, model, b, false, false);
    }

    public void valueHasMutated(JSObject data, String propertyName) {
        Knockout.valueHasMutated(data, propertyName);
    }

    public void expose(FunctionBinding fb, Object model, JSObject d) {
        Knockout.expose(d, fb);
    }

    public void applyBindings(JSObject data) {
        Knockout.applyBindings(data);
    }

    public Object wrapArray(Object[] arr) {
        return Knockout.toArray(arr);
    }

    public void extract(Object obj, String[] props, Object[] values) {
        LoadJSON.extractJSON(obj, props, values);
    }

    public void loadJSON(JSONCall call) {
        LoadJSON.loadJSON(call);
    }

    public <M> M toModel(Class<M> modelClass, Object data) {
        if (data instanceof JSObject) {
            data = ((JSObject)data).getMember("ko-fx.model");
        }
        return modelClass.cast(data);
    }

    public Object toJSON(InputStream is) throws IOException {
        return LoadJSON.parse(is);
    }
}

