/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.kofx;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javafx.application.Platform;
import net.java.html.js.JavaScriptBody;
import netscape.javascript.JSObject;
import org.apidesign.html.boot.impl.FnUtils;
import org.apidesign.html.boot.spi.Fn;
import org.apidesign.html.context.spi.Contexts;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;
import org.apidesign.html.json.spi.WSTransfer;
import org.apidesign.html.kofx.Knockout;
import org.apidesign.html.kofx.LoadJSON;
import org.apidesign.html.kofx.LoadWS;

public final class FXContext
implements Technology.BatchInit<JSObject>,
Transfer,
WSTransfer<LoadWS> {
    static final Logger LOG = Logger.getLogger(FXContext.class.getName());
    private static Boolean javaScriptEnabled;
    private final Fn.Presenter browserContext;

    public FXContext(Fn.Presenter browserContext) {
        this.browserContext = browserContext;
    }

    @JavaScriptBody(args={}, body="return true;")
    private static boolean isJavaScriptEnabledJs() {
        return false;
    }

    static boolean isJavaScriptEnabled() {
        if (javaScriptEnabled != null) {
            return javaScriptEnabled;
        }
        javaScriptEnabled = FXContext.isJavaScriptEnabledJs();
        return javaScriptEnabled;
    }

    final boolean areWebSocketsSupported() {
        return LoadWS.isSupported();
    }

    public JSObject wrapModel(Object model, PropertyBinding[] propArr, FunctionBinding[] funcArr) {
        String[] propNames = new String[propArr.length];
        boolean[] propReadOnly = new boolean[propArr.length];
        Object[] propValues = new Object[propArr.length];
        for (int i = 0; i < propNames.length; ++i) {
            propNames[i] = propArr[i].getPropertyName();
            propReadOnly[i] = propArr[i].isReadOnly();
            propValues[i] = propArr[i].getValue();
        }
        String[] funcNames = new String[funcArr.length];
        for (int i = 0; i < funcNames.length; ++i) {
            funcNames[i] = funcArr[i].getFunctionName();
        }
        return Knockout.wrapModel(model, propNames, propReadOnly, Knockout.toArray(propValues), propArr, funcNames, funcArr);
    }

    public JSObject wrapModel(Object model) {
        throw new UnsupportedOperationException();
    }

    public void bind(PropertyBinding b, Object model, JSObject data) {
        throw new UnsupportedOperationException();
    }

    public void valueHasMutated(JSObject data, String propertyName) {
        Knockout.valueHasMutated(data, propertyName);
    }

    public void expose(FunctionBinding fb, Object model, JSObject d) {
        throw new UnsupportedOperationException();
    }

    public void applyBindings(JSObject data) {
        Knockout.applyBindings(data);
    }

    public Object wrapArray(Object[] arr) {
        return Knockout.toArray(arr);
    }

    public void extract(Object obj, String[] props, Object[] values) {
        LoadJSON.extractJSON(obj, props, values);
    }

    public void loadJSON(JSONCall call) {
        LoadJSON.loadJSON(call);
    }

    public <M> M toModel(Class<M> modelClass, Object data) {
        if (data instanceof JSObject) {
            data = ((JSObject)data).getMember("ko-fx.model");
        }
        return modelClass.cast(data);
    }

    public Object toJSON(InputStream is) throws IOException {
        return LoadJSON.parse(is);
    }

    public void runSafe(final Runnable r) {
        class Wrap
        implements Runnable {
            Wrap() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Fn.Presenter prev = FnUtils.currentPresenter((Fn.Presenter)FXContext.this.browserContext);
                try {
                    r.run();
                }
                finally {
                    FnUtils.currentPresenter((Fn.Presenter)prev);
                }
            }
        }
        Wrap w = new Wrap();
        if (Platform.isFxApplicationThread()) {
            w.run();
        } else {
            Platform.runLater((Runnable)w);
        }
    }

    public LoadWS open(String url, JSONCall onReply) {
        return new LoadWS(onReply, url);
    }

    public void send(LoadWS socket, JSONCall data) {
        socket.send(data);
    }

    public void close(LoadWS socket) {
        socket.close();
    }

    public static final class Prvdr
    implements Contexts.Provider {
        public void fillContext(Contexts.Builder context, Class<?> requestor) {
            if (FXContext.isJavaScriptEnabled()) {
                FXContext c = new FXContext(FnUtils.currentPresenter());
                context.register(Technology.class, (Object)c, 100);
                context.register(Transfer.class, (Object)c, 100);
                if (c.areWebSocketsSupported()) {
                    context.register(WSTransfer.class, (Object)c, 100);
                }
            }
        }
    }
}

