/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.kofx;

import net.java.html.js.JavaScriptBody;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.kofx.LoadJSON;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

final class LoadWS {
    private static final boolean SUPPORTED = LoadWS.isWebSocket();
    private final Object ws;
    private final JSONCall call;

    LoadWS(JSONCall first, String url) {
        this.call = first;
        this.ws = LoadWS.initWebSocket(this, url);
        if (this.ws == null) {
            first.notifyError((Throwable)new IllegalArgumentException("Wrong URL: " + url));
        }
    }

    static boolean isSupported() {
        return SUPPORTED;
    }

    void send(JSONCall call) {
        this.push(call);
    }

    private synchronized void push(JSONCall call) {
        this.send(this.ws, call.getMessage());
    }

    void onOpen(Object ev) {
        if (!this.call.isDoOutput()) {
            this.call.notifySuccess(null);
        }
    }

    void onMessage(Object ev, String data) {
        Object json;
        try {
            data = data.trim();
            JSONTokener tok = new JSONTokener(data);
            JSONArray obj = data.startsWith("[") ? new JSONArray(tok) : new JSONObject(tok);
            json = LoadJSON.convertToArray(obj);
        }
        catch (JSONException ex) {
            json = data;
        }
        this.call.notifySuccess(json);
    }

    void onError(Object ev) {
        this.call.notifyError((Throwable)new Exception(ev.toString()));
    }

    void onClose(boolean wasClean, int code, String reason) {
        this.call.notifyError(null);
    }

    @JavaScriptBody(args={}, body="if (window.WebSocket) return true; else return false;")
    private static boolean isWebSocket() {
        return false;
    }

    @JavaScriptBody(args={"back", "url"}, javacall=true, body="if (window.WebSocket) {  try {    var ws = new window.WebSocket(url);    ws.onopen = function(ev) { back.@org.apidesign.html.kofx.LoadWS::onOpen(Ljava/lang/Object;)(ev); };    ws.onmessage = function(ev) { back.@org.apidesign.html.kofx.LoadWS::onMessage(Ljava/lang/Object;Ljava/lang/String;)(ev, ev.data); };    ws.onerror = function(ev) { back.@org.apidesign.html.kofx.LoadWS::onError(Ljava/lang/Object;)(ev); };    ws.onclose = function(ev) { back.@org.apidesign.html.kofx.LoadWS::onClose(ZILjava/lang/String;)(ev.wasClean, ev.code, ev.reason); };    return ws;  } catch (ex) {    return null;  }} else {  return null;}")
    private static Object initWebSocket(Object back, String url) {
        return null;
    }

    @JavaScriptBody(args={"ws", "msg"}, body="ws.send(msg);")
    private void send(Object ws, String msg) {
    }

    @JavaScriptBody(args={"ws"}, body="ws.close();")
    private static void close(Object ws) {
    }

    void close() {
        LoadWS.close(this.ws);
    }
}

