/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.jpa;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.appfuse.dao.UserDao;
import org.appfuse.dao.jpa.GenericDaoJpa;
import org.appfuse.model.User;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDaoJpa
extends GenericDaoJpa<User, Long>
implements UserDao,
UserDetailsService {
    private DataSource dataSource;

    public UserDaoJpa(DataSource dataSource) {
        super(User.class);
        this.dataSource = dataSource;
    }

    @Override
    public List<User> getUsers() {
        Query q = this.entityManager.createQuery("select u from User u order by upper(u.username)");
        return q.getResultList();
    }

    @Override
    @Transactional
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Query q = this.entityManager.createQuery("select u from User u where username=?");
        q.setParameter(1, (Object)username);
        List users = q.getResultList();
        if (users == null || users.isEmpty()) {
            throw new UsernameNotFoundException("user '" + username + "' not found...");
        }
        return (UserDetails)users.get(0);
    }

    @Override
    public User saveUser(User user) {
        User u = super.save(user);
        this.entityManager.flush();
        return u;
    }

    @Override
    public String getUserPassword(String username) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        Table table = (Table)AnnotationUtils.findAnnotation(User.class, Table.class);
        return (String)jdbcTemplate.queryForObject("select password from " + table.name() + " where username=?", String.class, new Object[]{username});
    }
}

