/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.jpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.dao.GenericDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoJpa<T, PK extends Serializable>
implements GenericDao<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String PERSISTENCE_UNIT_NAME = "ApplicationEntityManager";
    @PersistenceContext(unitName="ApplicationEntityManager")
    private EntityManager entityManager;
    private Class<T> persistentClass;

    public GenericDaoJpa(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public GenericDaoJpa(Class<T> persistentClass, EntityManager entityManager) {
        this.persistentClass = persistentClass;
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public List<T> getAll() {
        return this.entityManager.createQuery("select obj from " + this.persistentClass.getName() + " obj").getResultList();
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        Object entity = this.entityManager.find(this.persistentClass, id);
        if (entity == null) {
            String msg = "Uh oh, '" + this.persistentClass + "' object with id '" + id + "' not found...";
            this.log.warn((Object)msg);
            throw new EntityNotFoundException(msg);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = this.entityManager.find(this.persistentClass, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        return (T)this.entityManager.merge(object);
    }

    @Override
    public void remove(PK id) {
        this.entityManager.remove(this.get(id));
    }
}

