/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.jpa;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.appfuse.dao.UserDao;
import org.appfuse.dao.jpa.GenericDaoJpa;
import org.appfuse.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="userDao")
public class UserDaoJpa
extends GenericDaoJpa<User, Long>
implements UserDao,
UserDetailsService {
    @Autowired
    private DataSource dataSource;

    public UserDaoJpa() {
        super(User.class);
    }

    @Override
    public List<User> getUsers() {
        Query q = this.getEntityManager().createQuery("select u from User u order by upper(u.username)");
        return q.getResultList();
    }

    @Override
    @Transactional
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Query q = this.getEntityManager().createQuery("select u from User u where username=?");
        q.setParameter(1, (Object)username);
        List users = q.getResultList();
        if (users == null || users.isEmpty()) {
            throw new UsernameNotFoundException("user '" + username + "' not found...");
        }
        return (UserDetails)users.get(0);
    }

    @Override
    public User saveUser(User user) {
        User u = super.save(user);
        this.getEntityManager().flush();
        return u;
    }

    @Override
    public String getUserPassword(String username) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        Table table = (Table)AnnotationUtils.findAnnotation(User.class, Table.class);
        return (String)jdbcTemplate.queryForObject("select password from " + table.name() + " where username=?", String.class, new Object[]{username});
    }
}

