/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.jpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.appfuse.dao.GenericDao;
import org.appfuse.dao.SearchException;
import org.appfuse.dao.jpa.HibernateSearchJpaTools;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;

public class GenericDaoJpa<T, PK extends Serializable>
implements GenericDao<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String PERSISTENCE_UNIT_NAME = "ApplicationEntityManager";
    @PersistenceContext(unitName="ApplicationEntityManager")
    private EntityManager entityManager;
    private Class<T> persistentClass;
    private Analyzer defaultAnalyzer;

    public GenericDaoJpa(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
        this.defaultAnalyzer = new StandardAnalyzer(Version.LUCENE_35);
    }

    public GenericDaoJpa(Class<T> persistentClass, EntityManager entityManager) {
        this.persistentClass = persistentClass;
        this.entityManager = entityManager;
        this.defaultAnalyzer = new StandardAnalyzer(Version.LUCENE_35);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public List<T> getAll() {
        return this.entityManager.createQuery("select obj from " + this.persistentClass.getName() + " obj").getResultList();
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        Object entity = this.entityManager.find(this.persistentClass, id);
        if (entity == null) {
            String msg = "Uh oh, '" + this.persistentClass + "' object with id '" + id + "' not found...";
            this.log.warn((Object)msg);
            throw new EntityNotFoundException(msg);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = this.entityManager.find(this.persistentClass, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        return (T)this.entityManager.merge(object);
    }

    @Override
    public void remove(T object) {
        this.entityManager.remove(object);
    }

    @Override
    public void remove(PK id) {
        this.entityManager.remove(this.get(id));
    }

    @Override
    public List<T> search(String searchTerm) throws SearchException {
        Query qry;
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        try {
            qry = HibernateSearchJpaTools.generateQuery(searchTerm, this.persistentClass, this.entityManager, this.defaultAnalyzer);
        }
        catch (ParseException ex) {
            throw new SearchException(ex);
        }
        FullTextQuery hibQuery = fullTextEntityManager.createFullTextQuery(qry, new Class[]{this.persistentClass});
        return hibQuery.getResultList();
    }

    @Override
    public void reindex() {
        HibernateSearchJpaTools.reindex(this.persistentClass, this.getEntityManager());
    }

    @Override
    public void reindexAll(boolean async) {
        HibernateSearchJpaTools.reindexAll(async, this.getEntityManager());
    }
}

