/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.Transactional;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-resources.xml", "classpath:/applicationContext-dao.xml", "classpath*:/applicationContext.xml", "classpath:**/applicationContext*.xml"})
@Transactional
public abstract class BaseDaoTestCase {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected ResourceBundle rb;

    public BaseDaoTestCase() {
        String className = this.getClass().getName();
        try {
            this.rb = ResourceBundle.getBundle(className);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected Object populate(Object obj) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> keys = this.rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, this.rb.getString(key));
        }
        BeanUtils.copyProperties((Object)obj, map);
        return obj;
    }

    @Autowired
    public void flushSearchIndexes(ApplicationContext applicationContext) {
        EntityManagerFactory entityManagerFactory = (EntityManagerFactory)applicationContext.getBean("entityManagerFactory");
        FullTextEntityManager fullTextEntityMgr = Search.getFullTextEntityManager((EntityManager)entityManagerFactory.createEntityManager());
        fullTextEntityMgr.flushToIndexes();
    }
}

