/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.jpa;

import java.util.HashSet;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;

public class HibernateSearchJpaTools {
    protected static final Log log = LogFactory.getLog(HibernateSearchJpaTools.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Query generateQuery(String searchTerm, Class searchedEntity, EntityManager entityManager, Analyzer defaultAnalyzer) throws ParseException {
        MatchAllDocsQuery qry = null;
        if (searchTerm.equals("*")) {
            return new MatchAllDocsQuery();
        }
        IndexReaderAccessor readerAccessor = null;
        IndexReader reader = null;
        try {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)entityManager);
            Analyzer analyzer = searchedEntity == null ? defaultAnalyzer : fullTextEntityManager.getSearchFactory().getAnalyzer(searchedEntity);
            SearchFactory searchFactory = fullTextEntityManager.getSearchFactory();
            readerAccessor = searchFactory.getIndexReaderAccessor();
            reader = readerAccessor.open(new Class[]{searchedEntity});
            HashSet<String> fieldNames = new HashSet<String>();
            for (FieldInfo fieldInfo : ReaderUtil.getMergedFieldInfos((IndexReader)reader)) {
                if (!fieldInfo.isIndexed) continue;
                fieldNames.add(fieldInfo.name);
            }
            fieldNames.remove("_hibernate_class");
            String[] fnames = new String[]{};
            fnames = fieldNames.toArray(fnames);
            String[] queries = new String[fnames.length];
            for (int i = 0; i < queries.length; ++i) {
                queries[i] = searchTerm;
            }
            qry = MultiFieldQueryParser.parse((Version)Version.LUCENE_36, (String[])queries, (String[])fnames, (Analyzer)analyzer);
            if (readerAccessor == null) return qry;
            if (reader == null) return qry;
        }
        catch (Throwable throwable) {
            if (readerAccessor == null) throw throwable;
            if (reader == null) throw throwable;
            readerAccessor.close(reader);
            throw throwable;
        }
        readerAccessor.close(reader);
        return qry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reindex(Class clazz, EntityManager entityManager) {
        FullTextEntityManager txtentityManager = Search.getFullTextEntityManager((EntityManager)entityManager);
        MassIndexer massIndexer = txtentityManager.createIndexer(new Class[]{clazz});
        try {
            massIndexer.startAndWait();
        }
        catch (InterruptedException e) {
            log.error((Object)("mass reindexing interrupted: " + e.getMessage()));
        }
        finally {
            txtentityManager.flushToIndexes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reindexAll(boolean async, EntityManager entityManager) {
        FullTextEntityManager txtentityManager = Search.getFullTextEntityManager((EntityManager)entityManager);
        MassIndexer massIndexer = txtentityManager.createIndexer(new Class[0]);
        massIndexer.purgeAllOnStart(true);
        try {
            if (!async) {
                massIndexer.startAndWait();
            } else {
                massIndexer.start();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)("mass reindexing interrupted: " + e.getMessage()));
        }
        finally {
            txtentityManager.flushToIndexes();
        }
    }
}

