/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.web;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

@Controller
@RequestMapping(value={"/userform.*"})
public class UserFormController
extends SimpleFormController {
    private final Log log = LogFactory.getLog(UserFormController.class);
    @Autowired
    UserManager userManager;

    public UserFormController() {
        this.setCommandName("user");
        this.setCommandClass(User.class);
        this.setFormView("userForm");
        this.setSuccessView("redirect:users.html");
    }

    @Autowired(required=false)
    public void setFormValidator(Validator validator) {
        if (validator != null) {
            this.setValidator(validator);
        }
    }

    public ModelAndView processFormSubmission(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (request.getParameter("cancel") != null) {
            return new ModelAndView(this.getSuccessView());
        }
        return super.processFormSubmission(request, response, command, errors);
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getText("date.format"));
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, null, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
        binder.registerCustomEditor(Long.class, null, (PropertyEditor)new CustomNumberEditor(Long.class, null, true));
    }

    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        this.log.debug((Object)"entering 'onSubmit' method...");
        User user = (User)command;
        if (request.getParameter("delete") != null) {
            this.userManager.removeUser(user.getId().toString());
            request.getSession().setAttribute("message", (Object)this.getText("user.deleted", user.getFullName()));
        } else {
            this.userManager.saveUser(user);
            request.getSession().setAttribute("message", (Object)this.getText("user.saved", user.getFullName()));
        }
        return new ModelAndView(this.getSuccessView());
    }

    protected Object formBackingObject(HttpServletRequest request) throws ServletException {
        String userId = request.getParameter("id");
        if (userId != null && !userId.equals("")) {
            return this.userManager.getUser(userId);
        }
        return new User();
    }

    public String getText(String msgKey) {
        return this.getMessageSourceAccessor().getMessage(msgKey);
    }

    public String getText(String msgKey, String arg) {
        return this.getText(msgKey, new Object[]{arg});
    }

    public String getText(String msgKey, Object[] args) {
        return this.getMessageSourceAccessor().getMessage(msgKey, args);
    }
}

