/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userform*"})
public class UserFormController {
    private final Log log = LogFactory.getLog(UserFormController.class);
    @Autowired
    UserManager userManager;
    @Autowired(required=false)
    Validator validator;
    private MessageSourceAccessor messages;

    @Autowired
    public void setMessages(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getText("date.format"));
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, null, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
        binder.registerCustomEditor(Long.class, null, (PropertyEditor)new CustomNumberEditor(Long.class, null, true));
    }

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(User user, BindingResult result, HttpServletRequest request) throws Exception {
        if (request.getParameter("cancel") != null) {
            return "redirect:users";
        }
        if (this.validator != null) {
            this.validator.validate((Object)user, (Errors)result);
            if (result.hasErrors()) {
                return "userform";
            }
        }
        this.log.debug((Object)"entering 'onSubmit' method...");
        if (request.getParameter("delete") != null) {
            this.userManager.removeUser(user.getId().toString());
            request.getSession().setAttribute("message", (Object)this.getText("user.deleted", user.getFullName()));
        } else {
            try {
                this.userManager.saveUser(user);
            }
            catch (UserExistsException uex) {
                result.addError(new ObjectError("user", uex.getMessage()));
                return "userform";
            }
            request.getSession().setAttribute("message", (Object)this.getText("user.saved", user.getFullName()));
        }
        return "redirect:users";
    }

    @ModelAttribute
    @RequestMapping(method={RequestMethod.GET})
    protected User getUser(HttpServletRequest request) {
        String userId = request.getParameter("id");
        if (userId != null && !userId.equals("")) {
            return this.userManager.getUser(userId);
        }
        return new User();
    }

    public String getText(String msgKey) {
        return this.messages.getMessage(msgKey);
    }

    public String getText(String msgKey, String arg) {
        return this.getText(msgKey, new Object[]{arg});
    }

    public String getText(String msgKey, Object[] args) {
        return this.messages.getMessage(msgKey, args);
    }
}

