/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.web;

import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.LocalizableMessage;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.integration.spring.SpringBean;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.web.BaseActionBean;
import org.springframework.orm.ObjectRetrievalFailureException;

public class UserFormBean
extends BaseActionBean {
    @SpringBean
    private UserManager userManager;
    private User user;
    private String id;

    public void setId(String id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    @ValidateNestedProperties(value={@Validate(field="username", required=true, minlength=2, maxlength=50), @Validate(field="password", required=true, minlength=2, maxlength=50), @Validate(field="email", required=true, minlength=4, maxlength=50)})
    public void setUser(User user) {
        this.user = user;
    }

    @DontValidate
    @DefaultHandler
    public Resolution view() {
        if (this.id != null) {
            try {
                this.user = this.userManager.getUser(this.id);
            }
            catch (ObjectRetrievalFailureException e) {
                e.printStackTrace();
                this.getContext().getMessages().add(new LocalizableMessage("user.missing", new Object[0]));
                return this.showList();
            }
        } else {
            this.user = new User();
        }
        return new ForwardResolution("/userForm.jsp");
    }

    @HandlesEvent(value="save")
    public Resolution save() throws UserExistsException {
        this.userManager.saveUser(this.user);
        this.getContext().getMessages().add(new LocalizableMessage("user.saved", new Object[]{this.user.getFullName()}));
        return this.showList();
    }

    @DontValidate
    @HandlesEvent(value="delete")
    public Resolution delete() {
        this.userManager.removeUser(this.user.getId().toString());
        this.getContext().getMessages().add(new LocalizableMessage("user.deleted", new Object[]{this.user.getFullName()}));
        return this.showList();
    }

    @DontValidate
    @HandlesEvent(value="cancel")
    public Resolution cancel() {
        return this.showList();
    }

    private Resolution showList() {
        return new RedirectResolution("/users.html").flash((ActionBean)this);
    }
}

