/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;

public class UserAction
extends ActionSupport {
    private final Log log = LogFactory.getLog(UserAction.class);
    private UserManager userManager;
    private List<User> users;
    private User user;
    private String id;
    private String cancel;
    private String delete;

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String delete() {
        this.userManager.removeUser(this.user.getId().toString());
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getFullName());
        ActionContext.getContext().getSession().put("messages", this.getText("user.deleted", args));
        return "delete";
    }

    public String edit() {
        this.user = this.id != null ? this.userManager.getUser(this.id) : new User();
        return "success";
    }

    public String execute() {
        if (this.cancel != null) {
            return "cancel";
        }
        if (this.delete != null) {
            return this.delete();
        }
        return "success";
    }

    public String save() throws UserExistsException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"entering 'save' method");
        }
        try {
            this.userManager.saveUser(this.user);
        }
        catch (UserExistsException uex) {
            this.addActionError(this.getText("user.exists"));
            return "input";
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getFullName());
        ActionContext.getContext().getSession().put("messages", this.getText("user.saved", args));
        return "success";
    }

    public String list() {
        this.users = this.userManager.getUsers();
        return "success";
    }
}

