/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.web.pages;

import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.web.pages.UserList;
import org.appfuse.web.util.MessageUtil;
import org.slf4j.Logger;

public class UserForm {
    @Inject
    private Logger log;
    @Inject
    private Messages messages;
    @Inject
    private UserManager userManager;
    @Persist
    private User user;
    @Component(id="userForm")
    private Form form;
    private boolean cancel;
    private boolean delete;
    @InjectPage
    private UserList userList;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    void onValidateForm() {
        if (!this.delete && !this.cancel) {
            if (this.user.getUsername() == null || this.user.getUsername().trim().equals("")) {
                this.form.recordError("Username is a required field.");
            }
            if (this.user.getPassword() == null || this.user.getPassword().trim().equals("")) {
                this.form.recordError("Password is a required field.");
            }
            if (this.user.getEmail() == null || this.user.getEmail().trim().equals("")) {
                this.form.recordError("E-Mail is a required field.");
            }
        }
    }

    void onActivate(String id) {
        if (id != null) {
            this.user = this.userManager.getUser(id);
        }
    }

    Object onSuccess() throws UserExistsException {
        if (this.delete) {
            return this.onDelete();
        }
        if (this.cancel) {
            return this.onCancel();
        }
        this.log.debug("Saving user...");
        this.userManager.saveUser(this.user);
        String msg = MessageUtil.convert((String)this.messages.get("user.saved"));
        String message = String.format(msg, this.user.getFullName());
        this.userList.setMessage(message);
        return this.userList;
    }

    void onSelectedFromDelete() {
        this.log.debug("Deleting user...");
        this.delete = true;
    }

    void onSelectedFromCancel() {
        this.log.debug("Cancelling form...");
        this.cancel = true;
    }

    Object onDelete() {
        String msg = MessageUtil.convert((String)this.messages.get("user.deleted"));
        String message = String.format(msg, this.user.getFullName());
        this.userManager.removeUser(this.user.getId().toString());
        this.userList.setMessage(message);
        return this.userList;
    }

    Object onCancel() {
        return this.userList;
    }
}

