/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.pages;

import java.text.MessageFormat;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Session;
import org.appfuse.webapp.util.MessageUtil;
import org.slf4j.Logger;

public class BasePage {
    @Inject
    private Logger logger;
    @Inject
    private Messages messages;
    @Persist(value="flash")
    private String message;
    @Persist(value="flash")
    private String type;
    @Inject
    private RequestGlobals globals;
    @Inject
    private Request request;
    @Inject
    private Context context;

    protected void addError(Form form, Field field, String message, boolean flag, Object ... args) {
        if (field == null || form == null) {
            return;
        }
        String errorMessage = this.buildMessage(message, flag, args);
        this.setMessage(errorMessage);
        form.recordError(field, errorMessage);
        this.setType("error");
    }

    protected void addError(String message, boolean flag, Object ... args) {
        this.setMessage(this.buildMessage(message, flag, args));
        this.setType("error");
    }

    public void addInfo(String message, boolean flag, Object ... args) {
        this.setMessage(this.buildMessage(message, flag, args));
        this.setType("success");
    }

    private String buildMessage(String key, boolean flag, Object ... args) {
        return flag ? this.getMessageText(key, args) : String.format(key, args);
    }

    public HttpServletRequest getRequest() {
        return this.globals.getHTTPServletRequest();
    }

    public HttpServletResponse getResponse() {
        return this.globals.getHTTPServletResponse();
    }

    public boolean hasErrors() {
        return this.request.getSession(true).getAttribute("errors") != null;
    }

    public ServletContext getServletContext() {
        return this.getRequest().getSession().getServletContext();
    }

    protected Session getSession() {
        return this.request.getSession(true);
    }

    protected String getText(String key) {
        return this.getMessages().get(key);
    }

    protected String getText(String key, Object arg) {
        if (arg == null) {
            return this.getText(key);
        }
        if (arg instanceof String) {
            return MessageFormat.format(this.getMessages().get(key), arg);
        }
        if (arg instanceof Object[]) {
            return MessageFormat.format(this.getMessages().get(key), (Object[])arg);
        }
        this.logger.error("argument '" + arg + "' not String or Object[]");
        return "";
    }

    protected String getMessageText(String key, Object ... args) {
        if (args == null) {
            return this.getMessages().get(key);
        }
        String msg = MessageUtil.convert((String)this.messages.get(key));
        return String.format(msg, args);
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

