/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.components;

import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.Request;
import org.appfuse.webapp.internal.MenuContext;

@SupportsInformalParameters
public class MenuItem {
    @Property
    @Parameter(required=true, defaultPrefix="literal", allowNull=false)
    private String name;
    @Property
    @Parameter(required=true, defaultPrefix="message", allowNull=false)
    private String title;
    @Property
    @Parameter(required=false, defaultPrefix="literal", allowNull=false)
    private String page;
    @Property
    @Parameter(defaultPrefix="literal", allowNull=true)
    private String description;
    @Property
    @Parameter(defaultPrefix="literal", allowNull=true)
    private String style;
    @Property
    @Parameter(value="false", defaultPrefix="prop", allowNull=false)
    private boolean disabled;
    @Property
    @Parameter(defaultPrefix="literal", allowNull=true)
    private String roles;
    @Property
    @Parameter(name="class", defaultPrefix="literal", allowNull=true)
    private String itemCssClass;
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;
    @Environmental
    private MenuContext menuContext;

    public String getUrl() {
        if (this.page == null) {
            return "#";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.request.getContextPath());
        if (this.page != null && !this.page.startsWith("/")) {
            sb.append("/");
        }
        sb.append(this.page);
        return sb.toString();
    }

    void beginRender(MarkupWriter writer) {
        List itemClass = CollectionFactory.newList();
        Element e = writer.element("li", new Object[0]);
        if (this.itemCssClass != null) {
            itemClass.add(this.itemCssClass);
        }
        if (this.menuContext.isActive(this.name)) {
            itemClass.add("active");
        }
        if (!itemClass.isEmpty()) {
            e.addClassName(new String[]{TapestryInternalUtils.toClassAttributeValue((List)itemClass)});
        }
        Element href = writer.element("a", new Object[]{"id", this.name, "href", this.getUrl(), "title", this.title});
        if (this.style != null) {
            href.attribute("style", this.style);
        }
        this.resources.renderInformalParameters(writer);
        writer.write(this.title);
        writer.end();
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }
}

