/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.pages;

import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.alerts.Duration;
import org.apache.tapestry5.alerts.Severity;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.PageActivationContext;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.webapp.pages.UserList;
import org.slf4j.Logger;

public class UserForm {
    @Inject
    private Logger log;
    @Inject
    private Messages messages;
    @Inject
    private UserManager userManager;
    @Inject
    private AlertManager alertManager;
    @PageActivationContext
    @Property
    private User user;
    @Component(id="userForm")
    private Form form;
    private boolean cancel;
    private boolean delete;

    void onPrepare() {
        if (this.user == null) {
            this.user = new User();
        }
    }

    void onValidateFromUserForm() {
        if (!this.delete && !this.cancel) {
            if (this.user.getUsername() == null || this.user.getUsername().trim().equals("")) {
                this.form.recordError("Username is a required field.");
            }
            if (this.user.getPassword() == null || this.user.getPassword().trim().equals("")) {
                this.form.recordError("Password is a required field.");
            }
            if (this.user.getEmail() == null || this.user.getEmail().trim().equals("")) {
                this.form.recordError("E-Mail is a required field.");
            }
        }
    }

    Object onSuccess() {
        if (this.delete) {
            return this.onDelete();
        }
        if (this.cancel) {
            return this.onCancel();
        }
        this.log.debug("Saving user...");
        try {
            this.userManager.saveUser(this.user);
        }
        catch (UserExistsException uex) {
            this.alertManager.error(this.messages.format("user.exists", new Object[0]));
            return null;
        }
        String message = this.messages.format("user.saved", new Object[]{this.user.getFullName()});
        this.alertManager.alert(Duration.TRANSIENT, Severity.INFO, message);
        return UserList.class;
    }

    void onSelectedFromDelete() {
        this.log.debug("Deleting user...");
        this.delete = true;
    }

    void onSelectedFromCancel() {
        this.log.debug("Cancelling form...");
        this.cancel = true;
    }

    Object onDelete() {
        String message = this.messages.format("user.deleted", new Object[]{this.user.getFullName()});
        this.userManager.removeUser(this.user.getId().toString());
        this.alertManager.alert(Duration.TRANSIENT, Severity.INFO, message);
        return UserList.class;
    }

    Object onCancel() {
        return UserList.class;
    }
}

