/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.web.pages;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.collections.MicroMap;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.web.pages.BasePage;
import org.appfuse.web.pages.UserForm;

public class UserForm
extends BasePage {
    @SpringBean
    private UserManager userManager;
    private final Page responsePage;

    public UserForm(Page responsePage) {
        this(responsePage, new User());
    }

    public UserForm(Page responsePage, User user) {
        this.responsePage = responsePage;
        1 form = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{form});
    }

    protected void onSaveUser(User user) {
        try {
            this.userManager.saveUser(user);
        }
        catch (UserExistsException uee) {
            uee.printStackTrace();
        }
        String message = MapVariableInterpolator.interpolate((String)this.getLocalizer().getString("user.saved", (Component)this), (Map)new MicroMap((Object)"name", (Object)user.getFullName()));
        this.getSession().info(message);
        FeedbackPanel feedback = (FeedbackPanel)this.responsePage.get("feedback");
        feedback.setVisible(true);
        feedback.setEscapeModelStrings(true);
        this.setRedirect(true);
        this.setResponsePage(this.responsePage);
    }

    protected void onDeleteUser(User user) {
        this.userManager.removeUser(user.getId().toString());
        String message = MapVariableInterpolator.interpolate((String)this.getLocalizer().getString("user.deleted", (Component)this), (Map)new MicroMap((Object)"name", (Object)user.getFullName()));
        this.getSession().info(message);
        this.responsePage.get("feedback").setVisible(true);
        this.setRedirect(true);
        this.setResponsePage(this.responsePage);
    }

    private void onCancelEditing() {
        this.setResponsePage(this.responsePage);
    }

    static /* synthetic */ void access$000(UserForm x0) {
        x0.onCancelEditing();
    }
}

