/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.pages;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.appfuse.model.User;
import org.appfuse.service.UserManager;
import org.appfuse.webapp.pages.UserModel;

public class SortableUserDataProvider
extends SortableDataProvider {
    private UserManager userManager;

    public SortableUserDataProvider(UserManager userManager) {
        this.userManager = userManager;
    }

    public SortableUserDataProvider() {
        this.setSort("firstName", true);
    }

    public Iterator iterator(int first, int count) {
        SortParam sp;
        List users = this.userManager.getUsers();
        if (first > 0) {
            users = users.subList(first, first + count);
        }
        if ((sp = this.getSort()) != null) {
            String sortColumn = sp.getProperty();
            BeanComparator comparator = new BeanComparator(sortColumn);
            if (!sp.isAscending()) {
                comparator = new ReverseComparator((Comparator)comparator);
            }
            Collections.sort(users, comparator);
        }
        return users.iterator();
    }

    public IModel model(Object object) {
        return new UserModel((User)object, this.userManager);
    }

    public int size() {
        return this.userManager.getUsers().size();
    }
}

