/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CurrencyConverter
implements Converter {
    protected final Log log = LogFactory.getLog(CurrencyConverter.class);
    protected final DecimalFormat formatter = new DecimalFormat("###,###.00");

    public final Object convert(Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("value (" + value + ") instance of String"));
            }
            try {
                if (StringUtils.isBlank((String)String.valueOf(value))) {
                    return null;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("converting '" + value + "' to a decimal"));
                }
                Number num = this.formatter.parse(String.valueOf(value));
                return num.doubleValue();
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        } else if (value instanceof Double) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("value (" + value + ") instance of Double"));
                this.log.debug((Object)("returning double: " + this.formatter.format(value)));
            }
            return this.formatter.format(value);
        }
        throw new ConversionException("Could not convert " + value + " to " + type.getName() + "!");
    }
}

