/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class DateUtil {
    private static Log log = LogFactory.getLog(DateUtil.class);
    private static String timePattern = "HH:mm";

    public static String getDatePattern() {
        String defaultDatePattern;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            defaultDatePattern = ResourceBundle.getBundle("ApplicationResources", locale).getString("date.format");
        }
        catch (MissingResourceException mse) {
            defaultDatePattern = "MM/dd/yyyy";
        }
        return defaultDatePattern;
    }

    public static String getDateTimePattern() {
        return DateUtil.getDatePattern() + " HH:mm:ss.S";
    }

    public static String getDate(Date aDate) {
        String returnValue = "";
        if (aDate != null) {
            SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static Date convertStringToDate(String aMask, String strDate) throws ParseException {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(aMask);
        if (log.isDebugEnabled()) {
            log.debug((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
        }
        try {
            date = df.parse(strDate);
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return date;
    }

    public static String getTimeNow(Date theTime) {
        return DateUtil.getDateTime(timePattern, theTime);
    }

    public static Calendar getToday() throws ParseException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
        String todayAsString = df.format(today);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.convertStringToDate(todayAsString));
        return cal;
    }

    public static String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static String convertDateToString(Date aDate) {
        return DateUtil.getDateTime(DateUtil.getDatePattern(), aDate);
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        Date aDate = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting date with pattern: " + DateUtil.getDatePattern()));
            }
            aDate = DateUtil.convertStringToDate(DateUtil.getDatePattern(), strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("Could not convert '" + strDate + "' to a date, throwing exception"));
            pe.printStackTrace();
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return aDate;
    }
}

