/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;

public class UserSecurityAdvice
implements MethodBeforeAdvice,
AfterReturningAdvice {
    public static final String ACCESS_DENIED = "Access Denied: Only administrators are allowed to modify other users.";
    protected final Log log = LogFactory.getLog(UserSecurityAdvice.class);

    public void before(Method method, Object[] args, Object target) throws Throwable {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx.getAuthentication() != null) {
            GrantedAuthority[] roles;
            Authentication auth = ctx.getAuthentication();
            boolean administrator = false;
            for (GrantedAuthority role1 : roles = auth.getAuthorities()) {
                if (!role1.getAuthority().equals("admin")) continue;
                administrator = true;
                break;
            }
            User user = (User)args[0];
            String username = user.getUsername();
            String currentUser = auth.getPrincipal() instanceof UserDetails ? ((UserDetails)auth.getPrincipal()).getUsername() : String.valueOf(auth.getPrincipal());
            if (username != null && !username.equals(currentUser)) {
                AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
                boolean signupUser = resolver.isAnonymous(auth);
                if (!signupUser) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Verifying that '" + currentUser + "' can modify '" + username + "'"));
                    }
                    if (!administrator) {
                        this.log.warn((Object)("Access Denied: '" + currentUser + "' tried to modify '" + username + "'!"));
                        throw new AccessDeniedException(ACCESS_DENIED);
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Registering new user '" + username + "'"));
                }
            } else if (username != null && username.equalsIgnoreCase(currentUser) && !administrator) {
                HashSet<String> userRoles = new HashSet<String>();
                if (user.getRoles() != null) {
                    Iterator i$ = user.getRoles().iterator();
                    while (i$.hasNext()) {
                        Role o;
                        Role role = o = (Role)i$.next();
                        userRoles.add(role.getName());
                    }
                }
                HashSet<String> authorizedRoles = new HashSet<String>();
                for (GrantedAuthority role1 : roles) {
                    authorizedRoles.add(role1.getAuthority());
                }
                if (!CollectionUtils.isEqualCollection(userRoles, authorizedRoles)) {
                    this.log.warn((Object)("Access Denied: '" + currentUser + "' tried to change their role(s)!"));
                    throw new AccessDeniedException(ACCESS_DENIED);
                }
            }
        }
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        User currentUser;
        Authentication auth;
        User user = (User)args[0];
        if (user.getVersion() != null && (auth = SecurityContextHolder.getContext().getAuthentication()) != null && auth.getPrincipal() instanceof UserDetails && (currentUser = (User)auth.getPrincipal()).getId().equals(user.getId())) {
            auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
    }
}

