/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityExistsException;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.appfuse.dao.UserDao;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.service.impl.UniversalManagerImpl;
import org.springframework.dao.DataIntegrityViolationException;

public class UserManagerImpl
extends UniversalManagerImpl
implements UserManager {
    private UserDao dao;

    public void setUserDao(UserDao dao) {
        this.dao = dao;
    }

    public User getUser(String userId) {
        return (User)this.dao.get((Serializable)new Long(userId));
    }

    public List getUsers(User user) {
        return this.dao.getUsers();
    }

    public void saveUser(User user) throws UserExistsException {
        if (user.getVersion() == null) {
            user.setUsername(user.getUsername().toLowerCase());
        }
        try {
            this.dao.saveUser(user);
        }
        catch (DataIntegrityViolationException e) {
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
        catch (EntityExistsException e) {
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
    }

    public void removeUser(String userId) {
        this.log.debug((Object)("removing user: " + userId));
        this.dao.remove((Serializable)new Long(userId));
    }

    public User getUserByUsername(String username) throws UsernameNotFoundException {
        return (User)this.dao.loadUserByUsername(username);
    }
}

