/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityExistsException;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.appfuse.dao.UserDao;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.service.UserService;
import org.appfuse.service.impl.UniversalManagerImpl;
import org.springframework.dao.DataIntegrityViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UserService", endpointInterface="org.appfuse.service.UserService")
public class UserManagerImpl
extends UniversalManagerImpl
implements UserManager,
UserService {
    private UserDao dao;

    @Override
    public void setUserDao(UserDao dao) {
        this.dao = dao;
    }

    @Override
    public User getUser(String userId) {
        return (User)this.dao.get((Serializable)new Long(userId));
    }

    @Override
    public List<User> getUsers(User user) {
        return this.dao.getUsers();
    }

    @Override
    public User saveUser(User user) throws UserExistsException {
        if (user.getVersion() == null) {
            user.setUsername(user.getUsername().toLowerCase());
        }
        try {
            return this.dao.saveUser(user);
        }
        catch (DataIntegrityViolationException e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
        catch (EntityExistsException e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
    }

    @Override
    public void removeUser(String userId) {
        this.log.debug((Object)("removing user: " + userId));
        this.dao.remove((Serializable)new Long(userId));
    }

    @Override
    public User getUserByUsername(String username) throws UsernameNotFoundException {
        return (User)this.dao.loadUserByUsername(username);
    }
}

