/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang.StringUtils;
import org.appfuse.util.DateConverter;
import org.appfuse.util.DateUtil;

public class TimestampConverter
extends DateConverter {
    public static final String TS_FORMAT = String.valueOf(DateUtil.getDatePattern()) + " HH:mm:ss.S";

    protected Object convertToDate(Class type, Object value) {
        SimpleDateFormat df = new SimpleDateFormat(TS_FORMAT);
        if (value instanceof String) {
            try {
                if (StringUtils.isEmpty((String)value.toString())) {
                    return null;
                }
                return df.parse((String)value);
            }
            catch (Exception exception) {
                throw new ConversionException("Error converting String to Timestamp");
            }
        }
        throw new ConversionException("Could not convert " + value.getClass().getName() + " to " + type.getName());
    }

    protected Object convertToString(Class type, Object value) {
        SimpleDateFormat df = new SimpleDateFormat(TS_FORMAT);
        if (value instanceof Date) {
            try {
                return df.format(value);
            }
            catch (Exception exception) {
                throw new ConversionException("Error converting Timestamp to String");
            }
        }
        return value.toString();
    }
}

