/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityExistsException;
import org.acegisecurity.providers.dao.DaoAuthenticationProvider;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.appfuse.dao.UserDao;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.service.UserService;
import org.appfuse.service.impl.UniversalManagerImpl;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataIntegrityViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UserService", endpointInterface="org.appfuse.service.UserService")
public class UserManagerImpl
extends UniversalManagerImpl
implements UserManager,
UserService {
    private UserDao dao;
    private DaoAuthenticationProvider authenticationProvider;

    @Override
    @Required
    public void setUserDao(UserDao dao) {
        this.dao = dao;
    }

    @Required
    public void setAuthenticationProvider(DaoAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @Override
    public User getUser(String userId) {
        return (User)this.dao.get((Serializable)new Long(userId));
    }

    @Override
    public List<User> getUsers(User user) {
        return this.dao.getUsers();
    }

    @Override
    public User saveUser(User user) throws UserExistsException {
        if (user.getVersion() == null) {
            user.setUsername(user.getUsername().toLowerCase());
        }
        boolean passwordChanged = false;
        if (this.authenticationProvider != null) {
            PasswordEncoder passwordEncoder = this.authenticationProvider.getPasswordEncoder();
            if (passwordEncoder != null) {
                if (user.getVersion() == null) {
                    passwordChanged = true;
                } else {
                    String currentPassword = this.dao.getUserPassword(user.getUsername());
                    if (currentPassword == null) {
                        passwordChanged = true;
                    } else if (!currentPassword.equals(user.getPassword())) {
                        passwordChanged = true;
                    }
                }
                if (passwordChanged) {
                    user.setPassword(passwordEncoder.encodePassword(user.getPassword(), null));
                }
            } else {
                this.log.warn((Object)"PasswordEncoder not set on AuthenticationProvider, skipping password encryption...");
            }
        } else {
            this.log.warn((Object)"AuthenticationProvider not set, skipping password encryption...");
        }
        try {
            return this.dao.saveUser(user);
        }
        catch (DataIntegrityViolationException e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
        catch (EntityExistsException e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
    }

    @Override
    public void removeUser(String userId) {
        this.log.debug((Object)("removing user: " + userId));
        this.dao.remove((Serializable)new Long(userId));
    }

    @Override
    public User getUserByUsername(String username) throws UsernameNotFoundException {
        return (User)this.dao.loadUserByUsername(username);
    }
}

