/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service;

import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class MailEngine {
    private final Log log = LogFactory.getLog(MailEngine.class);
    private MailSender mailSender;
    private VelocityEngine velocityEngine;
    private String defaultFrom;

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void setFrom(String from) {
        this.defaultFrom = from;
    }

    public void sendMessage(SimpleMailMessage msg, String templateName, Map model) {
        String result = null;
        try {
            result = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)templateName, (Map)model);
        }
        catch (VelocityException e) {
            e.printStackTrace();
            this.log.error((Object)e.getMessage());
        }
        msg.setText(result);
        this.send(msg);
    }

    public void send(SimpleMailMessage msg) throws MailException {
        try {
            this.mailSender.send(msg);
        }
        catch (MailException ex) {
            this.log.error((Object)ex.getMessage());
            throw ex;
        }
    }

    public void sendMessage(String[] recipients, String sender, ClassPathResource resource, String bodyText, String subject, String attachmentName) throws MessagingException {
        MimeMessage message = ((JavaMailSenderImpl)this.mailSender).createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setTo(recipients);
        if (sender == null) {
            helper.setFrom(this.defaultFrom);
        } else {
            helper.setFrom(sender);
        }
        helper.setText(bodyText);
        helper.setSubject(subject);
        helper.addAttachment(attachmentName, (InputStreamSource)resource);
        ((JavaMailSenderImpl)this.mailSender).send(message);
    }
}

