/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityExistsException;
import org.appfuse.dao.UserDao;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.service.UserService;
import org.appfuse.service.impl.UniversalManagerImpl;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.springframework.security.userdetails.UsernameNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UserService", endpointInterface="org.appfuse.service.UserService")
public class UserManagerImpl
extends UniversalManagerImpl
implements UserManager,
UserService {
    private UserDao dao;
    private PasswordEncoder passwordEncoder;

    @Override
    @Required
    public void setUserDao(UserDao dao) {
        this.dao = dao;
    }

    @Required
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public User getUser(String userId) {
        return (User)this.dao.get((Serializable)new Long(userId));
    }

    @Override
    public List<User> getUsers(User user) {
        return this.dao.getUsers();
    }

    @Override
    public User saveUser(User user) throws UserExistsException {
        if (user.getVersion() == null) {
            user.setUsername(user.getUsername().toLowerCase());
        }
        boolean passwordChanged = false;
        if (this.passwordEncoder != null) {
            if (user.getVersion() == null) {
                passwordChanged = true;
            } else {
                String currentPassword = this.dao.getUserPassword(user.getUsername());
                if (currentPassword == null) {
                    passwordChanged = true;
                } else if (!currentPassword.equals(user.getPassword())) {
                    passwordChanged = true;
                }
            }
            if (passwordChanged) {
                user.setPassword(this.passwordEncoder.encodePassword(user.getPassword(), null));
            }
        } else {
            this.log.warn((Object)"PasswordEncoder not set, skipping password encryption...");
        }
        try {
            return this.dao.saveUser(user);
        }
        catch (DataIntegrityViolationException e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
        catch (EntityExistsException e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
    }

    @Override
    public void removeUser(String userId) {
        this.log.debug((Object)("removing user: " + userId));
        this.dao.remove((Serializable)new Long(userId));
    }

    @Override
    public User getUserByUsername(String username) throws UsernameNotFoundException {
        return (User)this.dao.loadUserByUsername(username);
    }
}

