/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;

public class UserSecurityAdvice
implements MethodBeforeAdvice,
AfterReturningAdvice {
    public static final String ACCESS_DENIED = "Access Denied: Only administrators are allowed to modify other users.";
    private final Log log = LogFactory.getLog(UserSecurityAdvice.class);
    static /* synthetic */ Class class$0;

    public void before(Method method, Object[] args, Object target) throws Throwable {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx.getAuthentication() != null) {
            GrantedAuthority[] roles;
            Authentication auth = ctx.getAuthentication();
            boolean administrator = false;
            GrantedAuthority[] grantedAuthorityArray = roles = auth.getAuthorities();
            int n = 0;
            int n2 = grantedAuthorityArray.length;
            while (n < n2) {
                GrantedAuthority role1 = grantedAuthorityArray[n];
                if (role1.getAuthority().equals("ROLE_ADMIN")) {
                    administrator = true;
                    break;
                }
                ++n;
            }
            User user = (User)args[0];
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            boolean signupUser = resolver.isAnonymous(auth);
            if (!signupUser) {
                User currentUser = this.getCurrentUser(auth);
                if (user.getId() != null && !user.getId().equals(currentUser.getId()) && !administrator) {
                    this.log.warn((Object)("Access Denied: '" + currentUser.getUsername() + "' tried to modify '" + user.getUsername() + "'!"));
                    throw new AccessDeniedException(ACCESS_DENIED);
                }
                if (user.getId() != null && user.getId().equals(currentUser.getId()) && !administrator) {
                    HashSet<String> userRoles = new HashSet<String>();
                    if (user.getRoles() != null) {
                        for (Object o : user.getRoles()) {
                            Role role = (Role)o;
                            userRoles.add(role.getName());
                        }
                    }
                    HashSet<String> authorizedRoles = new HashSet<String>();
                    GrantedAuthority[] grantedAuthorityArray2 = roles;
                    int n3 = 0;
                    int n4 = grantedAuthorityArray2.length;
                    while (n3 < n4) {
                        GrantedAuthority role = grantedAuthorityArray2[n3];
                        authorizedRoles.add(role.getAuthority());
                        ++n3;
                    }
                    if (!CollectionUtils.isEqualCollection(userRoles, authorizedRoles)) {
                        this.log.warn((Object)("Access Denied: '" + currentUser.getUsername() + "' tried to change their role(s)!"));
                        throw new AccessDeniedException(ACCESS_DENIED);
                    }
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Registering new user '" + user.getUsername() + "'"));
            }
        }
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        User user = (User)args[0];
        if (user.getVersion() != null) {
            User currentUser;
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            boolean signupUser = resolver.isAnonymous(auth);
            if (auth != null && !signupUser && (currentUser = this.getCurrentUser(auth)).getId().equals(user.getId())) {
                auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication(auth);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private User getCurrentUser(Authentication auth) {
        void var2_2;
        User currentUser;
        if (auth.getPrincipal() instanceof UserDetails) {
            currentUser = (User)auth.getPrincipal();
        } else if (auth.getDetails() instanceof UserDetails) {
            currentUser = (User)auth.getDetails();
        } else {
            throw new AccessDeniedException("User not properly authenticated.");
        }
        return var2_2;
    }
}

