/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.dao.GenericDao;
import org.appfuse.service.GenericManager;
import org.compass.core.CompassHit;
import org.compass.core.support.search.CompassSearchCommand;
import org.compass.core.support.search.CompassSearchHelper;
import org.compass.core.support.search.CompassSearchResults;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericManagerImpl<T, PK extends Serializable>
implements GenericManager<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected GenericDao<T, PK> dao;
    @Autowired
    private CompassSearchHelper compass;

    public GenericManagerImpl() {
    }

    public GenericManagerImpl(GenericDao<T, PK> genericDao) {
        this.dao = genericDao;
    }

    @Override
    public List<T> getAll() {
        return this.dao.getAll();
    }

    @Override
    public T get(PK id) {
        return (T)this.dao.get(id);
    }

    @Override
    public boolean exists(PK id) {
        return this.dao.exists(id);
    }

    @Override
    public T save(T object) {
        return (T)this.dao.save(object);
    }

    @Override
    public void remove(PK id) {
        this.dao.remove(id);
    }

    @Override
    public List<T> search(String q, Class clazz) {
        if (q == null || "".equals(q.trim())) {
            return this.getAll();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        CompassSearchCommand command = new CompassSearchCommand(q);
        CompassSearchResults compassResults = this.compass.search(command);
        CompassHit[] hits = compassResults.getHits();
        if (this.log.isDebugEnabled() && clazz != null) {
            this.log.debug((Object)("Filtering by type: " + clazz.getName()));
        }
        for (CompassHit hit : hits) {
            if (clazz != null) {
                if (!hit.data().getClass().equals(clazz)) continue;
                results.add(hit.data());
                continue;
            }
            results.add(hit.data());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Number of results for '" + q + "': " + results.size()));
        }
        return results;
    }
}

