/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class UserSecurityAdvice
implements MethodBeforeAdvice,
AfterReturningAdvice {
    public static final String ACCESS_DENIED = "Access Denied: Only administrators are allowed to modify other users.";
    private final Log log = LogFactory.getLog(UserSecurityAdvice.class);

    public void before(Method method, Object[] args, Object target) throws Throwable {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx.getAuthentication() != null) {
            Authentication auth = ctx.getAuthentication();
            boolean administrator = false;
            Collection roles = auth.getAuthorities();
            for (GrantedAuthority role : roles) {
                if (!role.getAuthority().equals("ROLE_ADMIN")) continue;
                administrator = true;
                break;
            }
            User user = (User)args[0];
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            boolean signupUser = resolver.isAnonymous(auth);
            if (!signupUser) {
                User currentUser = this.getCurrentUser(auth);
                if (user.getId() != null && !user.getId().equals(currentUser.getId()) && !administrator) {
                    this.log.warn((Object)("Access Denied: '" + currentUser.getUsername() + "' tried to modify '" + user.getUsername() + "'!"));
                    throw new AccessDeniedException(ACCESS_DENIED);
                }
                if (user.getId() != null && user.getId().equals(currentUser.getId()) && !administrator) {
                    HashSet<String> userRoles = new HashSet<String>();
                    if (user.getRoles() != null) {
                        for (Object o : user.getRoles()) {
                            Role role = (Role)o;
                            userRoles.add(role.getName());
                        }
                    }
                    HashSet<String> authorizedRoles = new HashSet<String>();
                    for (Role role : roles) {
                        authorizedRoles.add(role.getAuthority());
                    }
                    if (!CollectionUtils.isEqualCollection(userRoles, authorizedRoles)) {
                        this.log.warn((Object)("Access Denied: '" + currentUser.getUsername() + "' tried to change their role(s)!"));
                        throw new AccessDeniedException(ACCESS_DENIED);
                    }
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Registering new user '" + user.getUsername() + "'"));
            }
        }
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        User user = (User)args[0];
        if (user.getVersion() != null) {
            User currentUser;
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            boolean signupUser = resolver.isAnonymous(auth);
            if (auth != null && !signupUser && (currentUser = this.getCurrentUser(auth)).getId().equals(user.getId())) {
                auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), (Collection)user.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication(auth);
            }
        }
    }

    private User getCurrentUser(Authentication auth) {
        User currentUser;
        if (auth.getPrincipal() instanceof UserDetails) {
            currentUser = (User)auth.getPrincipal();
        } else if (auth.getDetails() instanceof UserDetails) {
            currentUser = (User)auth.getDetails();
        } else {
            throw new AccessDeniedException("User not properly authenticated.");
        }
        return currentUser;
    }
}

