/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.LabelValue;

public final class ConvertUtil {
    private static final Log log = LogFactory.getLog(ConvertUtil.class);

    private ConvertUtil() {
    }

    public static Map<String, String> convertBundleToMap(ResourceBundle rb) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, rb.getString(key));
        }
        return map;
    }

    public static Map<String, String> convertListToMap(List<LabelValue> list) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (LabelValue option : list) {
            map.put(option.getLabel(), option.getValue());
        }
        return map;
    }

    public static Properties convertBundleToProperties(ResourceBundle rb) {
        Properties props = new Properties();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            props.put(key, rb.getString(key));
        }
        return props;
    }

    public static Object populateObject(Object obj, ResourceBundle rb) {
        try {
            Map<String, String> map = ConvertUtil.convertBundleToMap(rb);
            BeanUtils.copyProperties((Object)obj, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Exception occurred populating object: " + e.getMessage()));
        }
        return obj;
    }
}

