/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringUtils;
import org.appfuse.util.DateUtil;

public class DateConverter
implements Converter {
    public Object convert(Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (type == Timestamp.class) {
            return this.convertToDate(type, value, DateUtil.getDateTimePattern());
        }
        if (type == Date.class) {
            return this.convertToDate(type, value, DateUtil.getDatePattern());
        }
        if (type == String.class) {
            return this.convertToString(value);
        }
        throw new ConversionException("Could not convert " + value.getClass().getName() + " to " + type.getName());
    }

    protected Object convertToDate(Class<?> type, Object value, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        if (value instanceof String) {
            try {
                if (StringUtils.isEmpty((String)value.toString())) {
                    return null;
                }
                Date date = df.parse((String)value);
                if (type.equals(Timestamp.class)) {
                    return new Timestamp(date.getTime());
                }
                return date;
            }
            catch (Exception e) {
                throw new ConversionException("Error converting String to Date", (Throwable)e);
            }
        }
        throw new ConversionException("Could not convert " + value.getClass().getName() + " to " + type.getName());
    }

    protected Object convertToString(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
            if (value instanceof Timestamp) {
                df = new SimpleDateFormat(DateUtil.getDateTimePattern());
            }
            try {
                return df.format(value);
            }
            catch (Exception e) {
                throw new ConversionException("Error converting Date to String", (Throwable)e);
            }
        }
        return value.toString();
    }
}

