/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.List;
import javax.jws.WebService;
import org.appfuse.dao.UserDao;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.service.UserService;
import org.appfuse.service.impl.GenericManagerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userManager")
@WebService(serviceName="UserService", endpointInterface="org.appfuse.service.UserService")
public class UserManagerImpl
extends GenericManagerImpl<User, Long>
implements UserManager,
UserService {
    private PasswordEncoder passwordEncoder;
    private UserDao userDao;
    @Autowired(required=false)
    private SaltSource saltSource;

    @Autowired
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    @Autowired
    public void setUserDao(UserDao userDao) {
        this.dao = userDao;
        this.userDao = userDao;
    }

    @Override
    public User getUser(String userId) {
        return (User)this.userDao.get((Serializable)new Long(userId));
    }

    @Override
    public List<User> getUsers() {
        return this.userDao.getAllDistinct();
    }

    @Override
    public User saveUser(User user) throws UserExistsException {
        if (user.getVersion() == null) {
            user.setUsername(user.getUsername().toLowerCase());
        }
        boolean passwordChanged = false;
        if (this.passwordEncoder != null) {
            if (user.getVersion() == null) {
                passwordChanged = true;
            } else {
                String currentPassword = this.userDao.getUserPassword(user.getId());
                if (currentPassword == null) {
                    passwordChanged = true;
                } else if (!currentPassword.equals(user.getPassword())) {
                    passwordChanged = true;
                }
            }
            if (passwordChanged) {
                if (this.saltSource == null) {
                    user.setPassword(this.passwordEncoder.encodePassword(user.getPassword(), null));
                    this.log.warn((Object)"SaltSource not set, encrypting password w/o salt");
                } else {
                    user.setPassword(this.passwordEncoder.encodePassword(user.getPassword(), this.saltSource.getSalt((UserDetails)user)));
                }
            }
        } else {
            this.log.warn((Object)"PasswordEncoder not set, skipping password encryption...");
        }
        try {
            return this.userDao.saveUser(user);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
    }

    @Override
    public void removeUser(User user) {
        this.log.debug((Object)("removing user: " + user));
        this.userDao.remove((Object)user);
    }

    @Override
    public void removeUser(String userId) {
        this.log.debug((Object)("removing user: " + userId));
        this.userDao.remove((Serializable)new Long(userId));
    }

    @Override
    public User getUserByUsername(String username) throws UsernameNotFoundException {
        return (User)this.userDao.loadUserByUsername(username);
    }

    @Override
    public List<User> search(String searchTerm) {
        return super.search(searchTerm, User.class);
    }
}

