/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.impl.PasswordTokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component(value="passwordTokenManager")
public class PasswordTokenManagerImpl
implements PasswordTokenManager {
    private final Log log = LogFactory.getLog(PasswordTokenManagerImpl.class);
    private final SimpleDateFormat expirationTimeFormat = new SimpleDateFormat("yyyyMMddHHmm");
    private final int expirationTimeTokenLength = this.expirationTimeFormat.toPattern().length();
    @Qualifier(value="passwordTokenEncoder")
    @Autowired
    private PasswordEncoder passwordTokenEncoder;

    @Override
    public String generateRecoveryToken(User user) {
        if (user != null) {
            String tokenSource = this.getTokenSource(user);
            String expirationTimeStamp = this.expirationTimeFormat.format(this.getExpirationTime());
            return expirationTimeStamp + this.passwordTokenEncoder.encode((CharSequence)(expirationTimeStamp + tokenSource));
        }
        return null;
    }

    @Override
    public boolean isRecoveryTokenValid(User user, String token) {
        if (user != null && token != null) {
            String expirationTimeStamp = this.getTimestamp(token);
            String tokenWithoutTimestamp = this.getTokenWithoutTimestamp(token);
            String tokenSource = expirationTimeStamp + this.getTokenSource(user);
            Date expirationTime = this.parseTimestamp(expirationTimeStamp);
            return expirationTime != null && expirationTime.after(new Date()) && this.passwordTokenEncoder.matches((CharSequence)tokenSource, tokenWithoutTimestamp);
        }
        return false;
    }

    @Override
    public void invalidateRecoveryToken(User user, String token) {
    }

    private Date getExpirationTime() {
        return DateUtils.addDays((Date)new Date(), (int)1);
    }

    private String getTimestamp(String token) {
        return StringUtils.substring((String)token, (int)0, (int)this.expirationTimeTokenLength);
    }

    private String getTokenSource(User user) {
        return user.getEmail() + user.getVersion() + user.getPassword();
    }

    private String getTokenWithoutTimestamp(String token) {
        return StringUtils.substring((String)token, (int)this.expirationTimeTokenLength, (int)token.length());
    }

    private Date parseTimestamp(String timestamp) {
        try {
            return this.expirationTimeFormat.parse(timestamp);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

