/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.time.DateUtils;
import org.appfuse.model.User;
import org.appfuse.service.impl.PasswordTokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class PersistentPasswordTokenManagerImpl
implements PasswordTokenManager {
    private JdbcTemplate jdbcTemplate;
    private String deleteTokenSql = "delete from password_reset_token where username=?";
    private String insertTokenSql = "insert into password_reset_token (username, token, expiration_time) values (?, ?, ?)";
    private String selectTokenSql = "select count(token) from password_reset_token where username=? and token=? and expiration_time > NOW()";

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setDeleteTokenSql(String deleteTokenSql) {
        this.deleteTokenSql = deleteTokenSql;
    }

    public void setInsertTokenSql(String insertTokenSql) {
        this.insertTokenSql = insertTokenSql;
    }

    public void setSelectTokenSql(String selectTokenSql) {
        this.selectTokenSql = selectTokenSql;
    }

    @Override
    public String generateRecoveryToken(User user) {
        int length = RandomUtils.nextInt((int)16) + 16;
        String token = RandomStringUtils.randomAlphanumeric((int)length);
        this.persistToken(user, token);
        return token;
    }

    @Override
    public boolean isRecoveryTokenValid(User user, String token) {
        return this.isRecoveryTokenPersisted(user, token);
    }

    @Override
    public void invalidateRecoveryToken(User user, String token) {
        this.jdbcTemplate.update(this.deleteTokenSql, new Object[]{user.getUsername()});
    }

    protected void persistToken(User user, String token) {
        this.jdbcTemplate.update(this.deleteTokenSql, new Object[]{user.getUsername()});
        this.jdbcTemplate.update(this.insertTokenSql, new Object[]{user.getUsername(), token, this.getExpirationTime()});
    }

    protected boolean isRecoveryTokenPersisted(User user, String token) {
        Number count = (Number)this.jdbcTemplate.queryForObject(this.selectTokenSql, new Object[]{user.getUsername(), token}, Integer.class);
        return count != null && count.intValue() == 1;
    }

    private Date getExpirationTime() {
        return DateUtils.addDays((Date)new Date(), (int)1);
    }
}

