/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.service.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.lang.StringUtils;
import org.appfuse.dao.UserDao;
import org.appfuse.model.User;
import org.appfuse.service.MailEngine;
import org.appfuse.service.UserExistsException;
import org.appfuse.service.UserManager;
import org.appfuse.service.UserService;
import org.appfuse.service.impl.GenericManagerImpl;
import org.appfuse.service.impl.PasswordTokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service(value="userManager")
@WebService(serviceName="UserService", endpointInterface="org.appfuse.service.UserService")
public class UserManagerImpl
extends GenericManagerImpl<User, Long>
implements UserManager,
UserService {
    private PasswordEncoder passwordEncoder;
    private UserDao userDao;
    private MailEngine mailEngine;
    private SimpleMailMessage message;
    private PasswordTokenManager passwordTokenManager;
    private String passwordRecoveryTemplate = "passwordRecovery.vm";
    private String passwordUpdatedTemplate = "passwordUpdated.vm";

    @Override
    @Autowired
    @Qualifier(value="passwordEncoder")
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    @Autowired
    public void setUserDao(UserDao userDao) {
        this.dao = userDao;
        this.userDao = userDao;
    }

    @Autowired(required=false)
    public void setMailEngine(MailEngine mailEngine) {
        this.mailEngine = mailEngine;
    }

    @Autowired(required=false)
    public void setMailMessage(SimpleMailMessage message) {
        this.message = message;
    }

    @Autowired(required=false)
    public void setPasswordTokenManager(PasswordTokenManager passwordTokenManager) {
        this.passwordTokenManager = passwordTokenManager;
    }

    public void setPasswordRecoveryTemplate(String passwordRecoveryTemplate) {
        this.passwordRecoveryTemplate = passwordRecoveryTemplate;
    }

    public void setPasswordUpdatedTemplate(String passwordUpdatedTemplate) {
        this.passwordUpdatedTemplate = passwordUpdatedTemplate;
    }

    @Override
    public User getUser(String userId) {
        return (User)this.userDao.get((Serializable)new Long(userId));
    }

    @Override
    public List<User> getUsers() {
        return this.userDao.getAllDistinct();
    }

    @Override
    public User saveUser(User user) throws UserExistsException {
        if (user.getVersion() == null) {
            user.setUsername(user.getUsername().toLowerCase());
        }
        boolean passwordChanged = false;
        if (this.passwordEncoder != null) {
            if (user.getVersion() == null) {
                passwordChanged = true;
            } else {
                String currentPassword = this.userDao.getUserPassword(user.getId());
                if (currentPassword == null) {
                    passwordChanged = true;
                } else if (!currentPassword.equals(user.getPassword())) {
                    passwordChanged = true;
                }
            }
            if (passwordChanged) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
            }
        } else {
            this.log.warn((Object)"PasswordEncoder not set, skipping password encryption...");
        }
        try {
            return this.userDao.saveUser(user);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.warn((Object)e.getMessage());
            throw new UserExistsException("User '" + user.getUsername() + "' already exists!");
        }
    }

    @Override
    public void removeUser(User user) {
        this.log.debug((Object)("removing user: " + user));
        this.userDao.remove((Object)user);
    }

    @Override
    public void removeUser(String userId) {
        this.log.debug((Object)("removing user: " + userId));
        this.userDao.remove((Serializable)new Long(userId));
    }

    @Override
    public User getUserByUsername(String username) throws UsernameNotFoundException {
        return (User)this.userDao.loadUserByUsername(username);
    }

    @Override
    public List<User> search(String searchTerm) {
        return super.search(searchTerm, User.class);
    }

    @Override
    public String buildRecoveryPasswordUrl(User user, String urlTemplate) {
        String token = this.generateRecoveryToken(user);
        String username = user.getUsername();
        return StringUtils.replaceEach((String)urlTemplate, (String[])new String[]{"{username}", "{token}"}, (String[])new String[]{username, token});
    }

    @Override
    public String generateRecoveryToken(User user) {
        return this.passwordTokenManager.generateRecoveryToken(user);
    }

    @Override
    public boolean isRecoveryTokenValid(String username, String token) {
        return this.isRecoveryTokenValid(this.getUserByUsername(username), token);
    }

    @Override
    public boolean isRecoveryTokenValid(User user, String token) {
        return this.passwordTokenManager.isRecoveryTokenValid(user, token);
    }

    @Override
    public void sendPasswordRecoveryEmail(String username, String urlTemplate) {
        this.log.debug((Object)("Sending password recovery token to user: " + username));
        User user = this.getUserByUsername(username);
        String url = this.buildRecoveryPasswordUrl(user, urlTemplate);
        this.sendUserEmail(user, this.passwordRecoveryTemplate, url);
    }

    private void sendUserEmail(User user, String template, String url) {
        this.message.setTo(user.getFullName() + "<" + user.getEmail() + ">");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("applicationURL", url);
        this.mailEngine.sendMessage(this.message, template, model);
    }

    @Override
    public User updatePassword(String username, String currentPassword, String recoveryToken, String newPassword, String applicationUrl) throws UserExistsException {
        User user = this.getUserByUsername(username);
        if (this.isRecoveryTokenValid(user, recoveryToken)) {
            this.log.debug((Object)("Updating password from recovery token for user:" + username));
            user.setPassword(newPassword);
            user = this.saveUser(user);
            this.passwordTokenManager.invalidateRecoveryToken(user, recoveryToken);
            this.sendUserEmail(user, this.passwordUpdatedTemplate, applicationUrl);
            return user;
        }
        if (StringUtils.isNotBlank((String)currentPassword) && this.passwordEncoder.matches((CharSequence)currentPassword, user.getPassword())) {
            this.log.debug((Object)("Updating password (providing current password) for user:" + username));
            user.setPassword(newPassword);
            user = this.saveUser(user);
            return user;
        }
        return null;
    }
}

