/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.BaseObject;
import org.appfuse.model.User;
import org.appfuse.service.UserManager;
import org.appfuse.util.DateUtil;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public abstract class BaseControllerTestCase
extends AbstractTransactionalDataSourceSpringContextTests {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected User user;

    protected String[] getConfigLocations() {
        this.setAutowireMode(1);
        return new String[]{"classpath*:/applicationContext-resources.xml", "classpath*:/applicationContext-dao.xml", "classpath*:/applicationContext-service.xml", "/WEB-INF/applicationContext*.xml", "/WEB-INF/dispatcher-servlet.xml"};
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        UserManager userMgr = (UserManager)this.applicationContext.getBean("userManager");
        this.user = userMgr.getUserByUsername("tomcat");
        JavaMailSenderImpl mailSender = (JavaMailSenderImpl)this.applicationContext.getBean("mailSender");
        mailSender.setPort(2525);
        mailSender.setHost("localhost");
    }

    protected void onTearDownAfterTransaction() throws Exception {
        this.user = null;
    }

    protected ConfigurableApplicationContext loadContextLocations(String[] locations) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading additional configuration from: " + StringUtils.arrayToCommaDelimitedString((Object[])locations)));
        }
        XmlWebApplicationContext ctx = new XmlWebApplicationContext();
        ctx.setConfigLocations(locations);
        ctx.setServletContext((ServletContext)new MockServletContext());
        ctx.refresh();
        return ctx;
    }

    public MockHttpServletRequest newPost(String url) {
        return new MockHttpServletRequest("POST", url);
    }

    public MockHttpServletRequest newGet(String url) {
        return new MockHttpServletRequest("GET", url);
    }

    public void objectToRequestParameters(Object o, MockHttpServletRequest request) throws Exception {
        this.objectToRequestParameters(o, request, null);
    }

    public void objectToRequestParameters(Object o, MockHttpServletRequest request, String prefix) throws Exception {
        Class<?> clazz = o.getClass();
        AccessibleObject[] fields = this.getDeclaredFields(clazz);
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            Object field = ((Field)f).get(o);
            if (field == null) continue;
            if (field instanceof BaseObject) {
                if (prefix != null) {
                    this.objectToRequestParameters(field, request, prefix + "." + ((Field)f).getName());
                    continue;
                }
                this.objectToRequestParameters(field, request, ((Field)f).getName());
                continue;
            }
            if (field instanceof List || field instanceof Set) continue;
            String paramName = ((Field)f).getName();
            if (prefix != null) {
                paramName = prefix + "." + paramName;
            }
            String paramValue = String.valueOf(((Field)f).get(o));
            if (field instanceof Date && "null".equals(paramValue = DateUtil.convertDateToString((Date)((Date)((Field)f).get(o))))) {
                paramValue = "";
            }
            request.addParameter(paramName, paramValue);
        }
    }

    private Field[] getDeclaredFields(Class clazz) {
        Field[] f = new Field[]{};
        Class superClazz = clazz.getSuperclass();
        ArrayList<Field> rval = new ArrayList<Field>();
        if (superClazz != null) {
            rval.addAll(Arrays.asList(this.getDeclaredFields(superClazz)));
        }
        rval.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return rval.toArray(f);
    }
}

