/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserExistsException;
import org.appfuse.util.StringUtil;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class UserFormController
extends BaseFormController {
    private RoleManager roleManager;

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public UserFormController() {
        this.setCommandName("user");
        this.setCommandClass(User.class);
    }

    public ModelAndView processFormSubmission(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (request.getParameter("cancel") != null) {
            if (!StringUtils.equals((String)request.getParameter("from"), (String)"list")) {
                return new ModelAndView(this.getCancelView());
            }
            return new ModelAndView(this.getSuccessView());
        }
        return super.processFormSubmission(request, response, command, errors);
    }

    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        String[] userRoles;
        this.log.debug((Object)"entering 'onSubmit' method...");
        User user = (User)command;
        Locale locale = request.getLocale();
        if (request.getParameter("delete") != null) {
            this.getUserManager().removeUser(user.getId().toString());
            this.saveMessage(request, this.getText("user.deleted", user.getFullName(), locale));
            return new ModelAndView(this.getSuccessView());
        }
        Boolean encrypt = (Boolean)this.getConfiguration().get("encryptPassword");
        if (StringUtils.equals((String)request.getParameter("encryptPass"), (String)"true") && encrypt != null && encrypt.booleanValue()) {
            String algorithm = (String)this.getConfiguration().get("algorithm");
            if (algorithm == null) {
                this.log.debug((Object)"assuming testcase, setting algorithm to 'SHA'");
                algorithm = "SHA";
            }
            user.setPassword(StringUtil.encodePassword((String)user.getPassword(), (String)algorithm));
        }
        if (request.isUserInRole("admin") && (userRoles = request.getParameterValues("userRoles")) != null) {
            user.getRoles().clear();
            for (String roleName : userRoles) {
                user.addRole(this.roleManager.getRole(roleName));
            }
        }
        Integer originalVersion = user.getVersion();
        try {
            this.getUserManager().saveUser(user);
        }
        catch (UserExistsException e) {
            this.log.warn((Object)e.getMessage());
            errors.rejectValue("username", "errors.existing.user", new Object[]{user.getUsername(), user.getEmail()}, "duplicate user");
            user.setPassword(user.getConfirmPassword());
            user.setVersion(originalVersion);
            return this.showForm(request, response, errors);
        }
        if (!StringUtils.equals((String)request.getParameter("from"), (String)"list")) {
            this.saveMessage(request, this.getText("user.saved", user.getFullName(), locale));
            return new ModelAndView((View)new RedirectView("mainMenu.html"));
        }
        if (StringUtils.isBlank((String)request.getParameter("version"))) {
            this.saveMessage(request, this.getText("user.added", user.getFullName(), locale));
            this.message.setSubject(this.getText("signup.email.subject", locale));
            this.sendUserMessage(user, this.getText("newuser.email.message", user.getFullName(), locale), RequestUtil.getAppURL((HttpServletRequest)request));
            return new ModelAndView(this.getSuccessView());
        }
        this.saveMessage(request, this.getText("user.updated.byAdmin", user.getFullName(), locale));
        return this.showForm(request, response, errors);
    }

    protected ModelAndView showForm(HttpServletRequest request, HttpServletResponse response, BindException errors) throws Exception {
        if (!(request.isUserInRole("admin") || this.isFormSubmission(request) || !this.isAdd(request) && request.getParameter("id") == null)) {
            response.sendError(403);
            this.log.warn((Object)("User '" + request.getRemoteUser() + "' is trying to edit user with id '" + request.getParameter("id") + "'"));
            throw new AccessDeniedException("You do not have permission to modify other users.");
        }
        return super.showForm(request, response, errors);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        if (!this.isFormSubmission(request)) {
            User user;
            Authentication auth;
            String userId = request.getParameter("id");
            this.log.debug((Object)"checking for remember me login...");
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            SecurityContext ctx = SecurityContextHolder.getContext();
            if (ctx.getAuthentication() != null && resolver.isRememberMe(auth = ctx.getAuthentication())) {
                request.getSession().setAttribute("cookieLogin", (Object)"true");
                this.saveMessage(request, this.getText("userProfile.cookieLogin", request.getLocale()));
            }
            if (userId == null && !this.isAdd(request)) {
                user = this.getUserManager().getUserByUsername(request.getRemoteUser());
            } else if (!StringUtils.isBlank((String)userId) && !"".equals(request.getParameter("version"))) {
                user = this.getUserManager().getUser(userId);
            } else {
                user = new User();
                user.addRole(new Role("user"));
            }
            user.setConfirmPassword(user.getPassword());
            return user;
        }
        if (request.getParameter("id") != null && !"".equals(request.getParameter("id")) && request.getParameter("cancel") == null) {
            return this.getUserManager().getUser(request.getParameter("id"));
        }
        return super.formBackingObject(request);
    }

    protected void onBind(HttpServletRequest request, Object command) throws Exception {
        if (request.getParameter("delete") != null) {
            super.setValidateOnBinding(false);
        } else {
            super.setValidateOnBinding(true);
        }
    }

    protected boolean isAdd(HttpServletRequest request) {
        String method = request.getParameter("method");
        return method != null && method.equalsIgnoreCase("add");
    }
}

