/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.appfuse.model.User;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserExistsException;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.mail.MailException;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class SignupController
extends BaseFormController {
    private RoleManager roleManager;

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public SignupController() {
        this.setCommandName("user");
        this.setCommandClass(User.class);
    }

    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"entering 'onSubmit' method...");
        }
        User user = (User)command;
        Locale locale = request.getLocale();
        user.setEnabled(true);
        user.addRole(this.roleManager.getRole("ROLE_USER"));
        try {
            this.getUserManager().saveUser(user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            response.sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            errors.rejectValue("username", "errors.existing.user", new Object[]{user.getUsername(), user.getEmail()}, "duplicate user");
            user.setPassword(user.getConfirmPassword());
            return this.showForm(request, response, errors);
        }
        this.saveMessage(request, this.getText("user.registered", user.getUsername(), locale));
        request.getSession().setAttribute("registered", (Object)Boolean.TRUE);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user.getUsername(), (Object)user.getConfirmPassword(), user.getAuthorities());
        auth.setDetails((Object)user);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending user '" + user.getUsername() + "' an account information e-mail"));
        }
        this.message.setSubject(this.getText("signup.email.subject", locale));
        try {
            this.sendUserMessage(user, this.getText("signup.email.message", locale), RequestUtil.getAppURL((HttpServletRequest)request));
        }
        catch (MailException me) {
            this.saveError(request, me.getCause().getLocalizedMessage());
        }
        return new ModelAndView(this.getSuccessView());
    }
}

