/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.listener;

import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.ProviderManager;
import org.acegisecurity.providers.dao.DaoAuthenticationProvider;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.service.LookupManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StartupListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(StartupListener.class);

    public void contextInitialized(ServletContextEvent event) {
        log.debug((Object)"Initializing context...");
        ServletContext context = event.getServletContext();
        HashMap<String, Object> config = (HashMap<String, Object>)context.getAttribute("appConfig");
        if (config == null) {
            config = new HashMap<String, Object>();
        }
        if (context.getInitParameter("csstheme") != null) {
            config.put("csstheme", context.getInitParameter("csstheme"));
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        PasswordEncoder passwordEncoder = null;
        try {
            ProviderManager provider = (ProviderManager)ctx.getBean("authenticationManager");
            for (Object o : provider.getProviders()) {
                AuthenticationProvider p = (AuthenticationProvider)o;
                if (p instanceof RememberMeAuthenticationProvider) {
                    config.put("rememberMeEnabled", Boolean.TRUE);
                    continue;
                }
                if (!(p instanceof DaoAuthenticationProvider)) continue;
                passwordEncoder = ((DaoAuthenticationProvider)p).getPasswordEncoder();
            }
        }
        catch (NoSuchBeanDefinitionException n) {
            log.debug((Object)"authenticationManager bean not found, assuming test and ignoring...");
        }
        context.setAttribute("appConfig", config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remember Me Enabled? " + config.get("rememberMeEnabled")));
            if (passwordEncoder != null) {
                log.debug((Object)("Password Encryptor: " + passwordEncoder.getClass().getName()));
            }
            log.debug((Object)"Populating drop-downs...");
        }
        StartupListener.setupContext((ServletContext)context);
    }

    public static void setupContext(ServletContext context) {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        LookupManager mgr = (LookupManager)ctx.getBean("lookupManager");
        context.setAttribute("availableRoles", (Object)mgr.getAllRoles());
        log.debug((Object)"Drop-down initialization complete [OK]");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

