/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.listener;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.appfuse.model.User;

public class UserCounterListener
implements ServletContextListener,
HttpSessionAttributeListener {
    public static final String COUNT_KEY = "userCounter";
    public static final String USERS_KEY = "userNames";
    public static final String EVENT_KEY = "ACEGI_SECURITY_CONTEXT";
    private transient ServletContext servletContext;
    private int counter;
    private Set<User> users;

    public synchronized void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
        this.servletContext.setAttribute(COUNT_KEY, (Object)Integer.toString(this.counter));
    }

    public synchronized void contextDestroyed(ServletContextEvent event) {
        this.servletContext = null;
        this.users = null;
        this.counter = 0;
    }

    synchronized void incrementUserCounter() {
        this.counter = Integer.parseInt((String)this.servletContext.getAttribute(COUNT_KEY));
        ++this.counter;
        this.servletContext.setAttribute(COUNT_KEY, (Object)Integer.toString(this.counter));
    }

    synchronized void decrementUserCounter() {
        int counter = Integer.parseInt((String)this.servletContext.getAttribute(COUNT_KEY));
        if (--counter < 0) {
            counter = 0;
        }
        this.servletContext.setAttribute(COUNT_KEY, (Object)Integer.toString(counter));
    }

    synchronized void addUsername(User user) {
        this.users = (Set)this.servletContext.getAttribute(USERS_KEY);
        if (this.users == null) {
            this.users = new LinkedHashSet();
        }
        if (!this.users.contains(user)) {
            this.users.add(user);
            this.servletContext.setAttribute(USERS_KEY, (Object)this.users);
            this.incrementUserCounter();
        }
    }

    synchronized void removeUsername(User user) {
        this.users = (Set)this.servletContext.getAttribute(USERS_KEY);
        if (this.users != null) {
            this.users.remove(user);
        }
        this.servletContext.setAttribute(USERS_KEY, (Object)this.users);
        this.decrementUserCounter();
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (event.getName().equals(EVENT_KEY) && !this.isAnonymous()) {
            SecurityContext securityContext = (SecurityContext)event.getValue();
            if (securityContext.getAuthentication().getPrincipal() instanceof User) {
                User user = (User)securityContext.getAuthentication().getPrincipal();
                this.addUsername(user);
            }
        } else if (event.getName().equals("ACEGI_SECURITY_LAST_USERNAME")) {
            String username = (String)event.getValue();
            User user = new User(username);
            this.addUsername(user);
        }
    }

    private boolean isAnonymous() {
        AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null) {
            Authentication auth = ctx.getAuthentication();
            return resolver.isAnonymous(auth);
        }
        return true;
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        SecurityContext securityContext;
        Authentication auth;
        if (event.getName().equals(EVENT_KEY) && !this.isAnonymous() && (auth = (securityContext = (SecurityContext)event.getValue()).getAuthentication()) != null && auth.getPrincipal() instanceof User) {
            User user = (User)auth.getPrincipal();
            this.removeUsername(user);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        SecurityContext securityContext;
        if (event.getName().equals(EVENT_KEY) && !this.isAnonymous() && (securityContext = (SecurityContext)event.getValue()).getAuthentication() != null && securityContext.getAuthentication().getPrincipal() instanceof User) {
            User user = (User)securityContext.getAuthentication().getPrincipal();
            this.addUsername(user);
        }
    }
}

