/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.appfuse.Constants;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.controller.FileUpload;
import org.springframework.validation.BindException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

public class FileUploadController
extends BaseFormController {
    public FileUploadController() {
        this.setCommandName("fileUpload");
        this.setCommandClass(FileUpload.class);
    }

    public ModelAndView processFormSubmission(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (request.getParameter("cancel") != null) {
            return new ModelAndView(this.getCancelView());
        }
        return super.processFormSubmission(request, response, command, errors);
    }

    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        int bytesRead;
        FileUpload fileUpload = (FileUpload)command;
        if (fileUpload.getFile().length == 0) {
            Object[] args = new Object[]{this.getText("uploadForm.file", request.getLocale())};
            errors.rejectValue("file", "errors.required", args, "File");
            return this.showForm(request, response, errors);
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        CommonsMultipartFile file = (CommonsMultipartFile)multipartRequest.getFile("file");
        String uploadDir = this.getServletContext().getRealPath("/resources") + "/" + request.getRemoteUser() + "/";
        File dirPath = new File(uploadDir);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        InputStream stream = file.getInputStream();
        FileOutputStream bos = new FileOutputStream(uploadDir + file.getOriginalFilename());
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)bos).write(buffer, 0, bytesRead);
        }
        ((OutputStream)bos).close();
        stream.close();
        request.setAttribute("friendlyName", (Object)fileUpload.getName());
        request.setAttribute("fileName", (Object)file.getOriginalFilename());
        request.setAttribute("contentType", (Object)file.getContentType());
        request.setAttribute("size", (Object)(file.getSize() + " bytes"));
        request.setAttribute("location", (Object)(dirPath.getAbsolutePath() + Constants.FILE_SEP + file.getOriginalFilename()));
        String link = request.getContextPath() + "/resources" + "/" + request.getRemoteUser() + "/";
        request.setAttribute("link", (Object)(link + file.getOriginalFilename()));
        return new ModelAndView(this.getSuccessView());
    }
}

