/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.appfuse.model.User;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserExistsException;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/signup.*"})
public class SignupController
extends BaseFormController {
    private RoleManager roleManager;

    @Autowired
    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    @ModelAttribute
    @RequestMapping(method={RequestMethod.GET})
    public User showForm() {
        return new User();
    }

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(User user, BindingResult errors, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"entering 'onSubmit' method...");
        }
        Locale locale = request.getLocale();
        user.setEnabled(true);
        user.addRole(this.roleManager.getRole("ROLE_USER"));
        try {
            this.getUserManager().saveUser(user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            response.sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            errors.rejectValue("username", "errors.existing.user", new Object[]{user.getUsername(), user.getEmail()}, "duplicate user");
            user.setPassword(user.getConfirmPassword());
            return "signup";
        }
        this.saveMessage(request, this.getText("user.registered", user.getUsername(), locale));
        request.getSession().setAttribute("registered", (Object)Boolean.TRUE);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user.getUsername(), (Object)user.getConfirmPassword(), (Collection)user.getAuthorities());
        auth.setDetails((Object)user);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending user '" + user.getUsername() + "' an account information e-mail"));
        }
        this.message.setSubject(this.getText("signup.email.subject", locale));
        try {
            this.sendUserMessage(user, this.getText("signup.email.message", locale), RequestUtil.getAppURL((HttpServletRequest)request));
        }
        catch (MailException me) {
            this.saveError(request, me.getMostSpecificCause().getMessage());
        }
        return "redirect:mainMenu.html";
    }
}

