/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserExistsException;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userform.*"})
public class UserFormController
extends BaseFormController {
    private RoleManager roleManager;

    @Autowired
    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public UserFormController() {
        this.setCancelView("redirect:mainMenu.html");
        this.setSuccessView("redirect:admin/users.html");
    }

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(User user, BindingResult errors, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] userRoles;
        if (request.getParameter("cancel") != null) {
            if (!StringUtils.equals((String)request.getParameter("from"), (String)"list")) {
                return this.getCancelView();
            }
            return this.getSuccessView();
        }
        if (this.validator != null) {
            this.validator.validate((Object)user, (Errors)errors);
            if (errors.hasErrors() && request.getParameter("delete") == null) {
                return "userform";
            }
        }
        this.log.debug((Object)"entering 'onSubmit' method...");
        Locale locale = request.getLocale();
        if (request.getParameter("delete") != null) {
            this.getUserManager().removeUser(user.getId().toString());
            this.saveMessage(request, this.getText("user.deleted", user.getFullName(), locale));
            return this.getSuccessView();
        }
        if (request.isUserInRole("ROLE_ADMIN") && (userRoles = request.getParameterValues("userRoles")) != null) {
            user.getRoles().clear();
            for (String roleName : userRoles) {
                user.addRole(this.roleManager.getRole(roleName));
            }
        }
        Integer originalVersion = user.getVersion();
        try {
            this.getUserManager().saveUser(user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            response.sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            errors.rejectValue("username", "errors.existing.user", new Object[]{user.getUsername(), user.getEmail()}, "duplicate user");
            user.setPassword(user.getConfirmPassword());
            user.setVersion(originalVersion);
            return "userform";
        }
        if (!StringUtils.equals((String)request.getParameter("from"), (String)"list")) {
            this.saveMessage(request, this.getText("user.saved", user.getFullName(), locale));
            return this.getCancelView();
        }
        if (StringUtils.isBlank((String)request.getParameter("version"))) {
            this.saveMessage(request, this.getText("user.added", user.getFullName(), locale));
            this.message.setSubject(this.getText("signup.email.subject", locale));
            try {
                this.sendUserMessage(user, this.getText("newuser.email.message", user.getFullName(), locale), RequestUtil.getAppURL((HttpServletRequest)request));
            }
            catch (MailException me) {
                this.saveError(request, me.getCause().getLocalizedMessage());
            }
            return this.getSuccessView();
        }
        this.saveMessage(request, this.getText("user.updated.byAdmin", user.getFullName(), locale));
        return "userform";
    }

    @ModelAttribute
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    protected User showForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!(request.isUserInRole("ROLE_ADMIN") || this.isFormSubmission(request) || !this.isAdd(request) && request.getParameter("id") == null)) {
            response.sendError(403);
            this.log.warn((Object)("User '" + request.getRemoteUser() + "' is trying to edit user with id '" + request.getParameter("id") + "'"));
            throw new AccessDeniedException("You do not have permission to modify other users.");
        }
        if (!this.isFormSubmission(request)) {
            User user;
            Authentication auth;
            String userId = request.getParameter("id");
            this.log.debug((Object)"checking for remember me login...");
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            SecurityContext ctx = SecurityContextHolder.getContext();
            if (ctx.getAuthentication() != null && resolver.isRememberMe(auth = ctx.getAuthentication())) {
                request.getSession().setAttribute("cookieLogin", (Object)"true");
                this.saveMessage(request, this.getText("userProfile.cookieLogin", request.getLocale()));
            }
            if (userId == null && !this.isAdd(request)) {
                user = this.getUserManager().getUserByUsername(request.getRemoteUser());
            } else if (!StringUtils.isBlank((String)userId) && !"".equals(request.getParameter("version"))) {
                user = this.getUserManager().getUser(userId);
            } else {
                user = new User();
                user.addRole(new Role("ROLE_USER"));
            }
            user.setConfirmPassword(user.getPassword());
            return user;
        }
        return this.getUserManager().getUser(request.getParameter("id"));
    }

    private boolean isFormSubmission(HttpServletRequest request) {
        return request.getMethod().equalsIgnoreCase("post");
    }

    protected boolean isAdd(HttpServletRequest request) {
        String method = request.getParameter("method");
        return method != null && method.equalsIgnoreCase("add");
    }
}

