/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.MailEngine;
import org.appfuse.service.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

public class BaseFormController
implements ServletContextAware {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    public static final String MESSAGES_KEY = "successMessages";
    private UserManager userManager = null;
    protected MailEngine mailEngine = null;
    protected SimpleMailMessage message = null;
    protected String templateName = "accountCreated.vm";
    protected String cancelView;
    protected String successView;
    private MessageSourceAccessor messages;
    private ServletContext servletContext;
    @Autowired(required=false)
    Validator validator;

    @Autowired
    public void setMessages(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void saveError(HttpServletRequest request, String error) {
        ArrayList<String> errors = (ArrayList<String>)request.getSession().getAttribute("errors");
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        errors.add(error);
        request.getSession().setAttribute("errors", errors);
    }

    public void saveMessage(HttpServletRequest request, String msg) {
        ArrayList<String> messages = (ArrayList<String>)request.getSession().getAttribute(MESSAGES_KEY);
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(msg);
        request.getSession().setAttribute(MESSAGES_KEY, messages);
    }

    public String getText(String msgKey, Locale locale) {
        return this.messages.getMessage(msgKey, locale);
    }

    public String getText(String msgKey, String arg, Locale locale) {
        return this.getText(msgKey, new Object[]{arg}, locale);
    }

    public String getText(String msgKey, Object[] args, Locale locale) {
        return this.messages.getMessage(msgKey, args, locale);
    }

    public Map getConfiguration() {
        HashMap config = (HashMap)this.servletContext.getAttribute("appConfig");
        if (config == null) {
            return new HashMap();
        }
        return config;
    }

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.registerCustomEditor(Integer.class, null, (PropertyEditor)new CustomNumberEditor(Integer.class, null, true));
        binder.registerCustomEditor(Long.class, null, (PropertyEditor)new CustomNumberEditor(Long.class, null, true));
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getText("date.format", request.getLocale()));
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, null, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
    }

    protected void sendUserMessage(User user, String msg, String url) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sending e-mail to user [" + user.getEmail() + "]..."));
        }
        this.message.setTo(user.getFullName() + "<" + user.getEmail() + ">");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("message", msg);
        model.put("applicationURL", url);
        this.mailEngine.sendMessage(this.message, this.templateName, model);
    }

    @Autowired
    public void setMailEngine(MailEngine mailEngine) {
        this.mailEngine = mailEngine;
    }

    @Autowired
    public void setMessage(SimpleMailMessage message) {
        this.message = message;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public final BaseFormController setCancelView(String cancelView) {
        this.cancelView = cancelView;
        return this;
    }

    public final String getCancelView() {
        if (this.cancelView == null || this.cancelView.length() == 0) {
            return this.getSuccessView();
        }
        return this.cancelView;
    }

    public final String getSuccessView() {
        return this.successView;
    }

    public final BaseFormController setSuccessView(String successView) {
        this.successView = successView;
        return this;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }
}

