/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.model.User;
import org.appfuse.service.MailEngine;
import org.appfuse.service.UserManager;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/passwordHint*"})
public class PasswordHintController {
    private final Log log = LogFactory.getLog(PasswordHintController.class);
    private UserManager userManager = null;
    private MessageSource messageSource = null;
    protected MailEngine mailEngine = null;
    protected SimpleMailMessage message = null;

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Autowired
    public void setMailEngine(MailEngine mailEngine) {
        this.mailEngine = mailEngine;
    }

    @Autowired
    public void setMessage(SimpleMailMessage message) {
        this.message = message;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView handleRequest(HttpServletRequest request) throws Exception {
        this.log.debug((Object)"entering 'handleRequest' method...");
        String username = request.getParameter("username");
        MessageSourceAccessor text = new MessageSourceAccessor(this.messageSource, request.getLocale());
        if (username == null) {
            this.log.warn((Object)"Username not specified, notifying user that it's a required field.");
            request.setAttribute("error", (Object)text.getMessage("errors.required", text.getMessage("user.username")));
            return new ModelAndView("login");
        }
        this.log.debug((Object)"Processing Password Hint...");
        try {
            User user = this.userManager.getUserByUsername(username);
            StringBuffer msg = new StringBuffer();
            msg.append("Your password hint is: ").append(user.getPasswordHint());
            msg.append("\n\nLogin at: ").append(RequestUtil.getAppURL((HttpServletRequest)request));
            this.message.setTo(user.getEmail());
            String subject = '[' + text.getMessage("webapp.name") + "] " + text.getMessage("user.passwordHint");
            this.message.setSubject(subject);
            this.message.setText(msg.toString());
            this.mailEngine.send(this.message);
            this.saveMessage(request, text.getMessage("login.passwordHint.sent", new Object[]{username, user.getEmail()}));
        }
        catch (UsernameNotFoundException e) {
            this.log.warn((Object)e.getMessage());
            this.saveError(request, text.getMessage("login.passwordHint.error", new Object[]{username}));
        }
        catch (MailException me) {
            this.log.warn((Object)me.getMessage());
            this.saveError(request, me.getCause().getLocalizedMessage());
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath()));
    }

    public void saveError(HttpServletRequest request, String error) {
        ArrayList<String> errors = (ArrayList<String>)request.getSession().getAttribute("errors");
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        errors.add(error);
        request.getSession().setAttribute("errors", errors);
    }

    public void saveMessage(HttpServletRequest request, String msg) {
        ArrayList<String> messages = (ArrayList<String>)request.getSession().getAttribute("successMessages");
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(msg);
        request.getSession().setAttribute("successMessages", messages);
    }
}

