/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.appfuse.webapp.filter.LocaleRequestWrapper;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class LocaleFilter
extends OncePerRequestFilter {
    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        String locale = request.getParameter("locale");
        Locale preferredLocale = null;
        if (locale != null) {
            int indexOfUnderscore = locale.indexOf(95);
            if (indexOfUnderscore != -1) {
                String language = locale.substring(0, indexOfUnderscore);
                String country = locale.substring(indexOfUnderscore + 1);
                preferredLocale = new Locale(language, country);
            } else {
                preferredLocale = new Locale(locale);
            }
        }
        if ((session = request.getSession(false)) != null) {
            if (preferredLocale == null) {
                preferredLocale = (Locale)session.getAttribute("org.apache.struts2.action.LOCALE");
            } else {
                session.setAttribute("org.apache.struts2.action.LOCALE", (Object)preferredLocale);
                Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)preferredLocale);
            }
            if (preferredLocale != null && !(request instanceof LocaleRequestWrapper)) {
                request = new LocaleRequestWrapper(request, preferredLocale);
                LocaleContextHolder.setLocale((Locale)preferredLocale);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        LocaleContextHolder.setLocaleContext(null);
    }
}

